/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.accessmanager;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Item;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.accessmanager.AccessControlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyAceServlet
extends HttpServlet {
    public static final String PRINCIPAL_ID = "principalId";
    public static final String RESOURCE_PATH = "resourcePath";
    public static final String ORDER = "order";
    public static final String PRIVILEGE = "privilege@";
    private Logger logger = LoggerFactory.getLogger(ModifyAceServlet.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logger.info("Servlet Modify Ace called ......");
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        SessionImpl session = null;
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        boolean modified = false;
        XStream xstream = null;
        String xmlConfig = null;
        try {
            try {
                xstream = new XStream();
                session = (SessionImpl)rep.login((Credentials)new SimpleCredentials(request.getParameter("adminId"), request.getParameter("adminPassword").toCharArray()));
                String resourcePath = new String(request.getParameter(RESOURCE_PATH).getBytes("iso-8859-1"), "UTF-8");
                String principalId = request.getParameter(PRINCIPAL_ID);
                String order = request.getParameter(ORDER);
                HashMap<String, String> privileges = new HashMap<String, String>();
                Enumeration parameterNames = request.getParameterNames();
                while (parameterNames.hasMoreElements()) {
                    String paramName;
                    Object nextElement = parameterNames.nextElement();
                    if (!(nextElement instanceof String) || !(paramName = (String)nextElement).startsWith(PRIVILEGE)) continue;
                    String privilegeName = paramName.substring(10);
                    String parameterValue = request.getParameter(paramName);
                    privileges.put(privilegeName, parameterValue);
                    this.logger.info("privilege@ " + privilegeName + " - parameterValue: " + parameterValue);
                }
                modified = this.modifyAce(session, resourcePath, principalId, privileges, order);
                xmlConfig = xstream.toXML((Object)modified);
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
            }
            catch (RepositoryException e) {
                modified = false;
                xmlConfig = xstream.toXML((Object)e);
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
                out.println(xmlConfig);
                if (session != null) {
                    session.logout();
                }
                out.close();
                out.flush();
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
            out.close();
            out.flush();
        }
    }

    public boolean modifyAce(SessionImpl jcrSession, String resourcePath, String principalId, Map<String, String> privileges, String order) throws RepositoryException {
        if (jcrSession == null) {
            return false;
        }
        if (principalId == null) {
            return false;
        }
        PrincipalManager principalManager = AccessControlUtil.getPrincipalManager((Session)jcrSession);
        Principal principal = principalManager.getPrincipal(principalId);
        if (resourcePath == null) {
            return false;
        }
        Item item = jcrSession.getItem(resourcePath);
        if (item == null) {
            return false;
        }
        resourcePath = item.getPath();
        HashSet<String> grantedPrivilegeNames = new HashSet<String>();
        HashSet<String> deniedPrivilegeNames = new HashSet<String>();
        HashSet<String> removedPrivilegeNames = new HashSet<String>();
        Set<Map.Entry<String, String>> entrySet = privileges.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String privilegeName = entry.getKey();
            if (privilegeName.startsWith(PRIVILEGE)) {
                privilegeName = privilegeName.substring(10);
            }
            this.logger.info("privileges: ");
            String parameterValue = entry.getValue();
            if (parameterValue == null || parameterValue.length() <= 0) continue;
            if ("granted".equals(parameterValue)) {
                this.logger.info("-granted: " + privilegeName);
                grantedPrivilegeNames.add(privilegeName);
                continue;
            }
            if ("denied".equals(parameterValue)) {
                this.logger.info("-denied: " + privilegeName);
                deniedPrivilegeNames.add(privilegeName);
                continue;
            }
            if (!"none".equals(parameterValue)) continue;
            this.logger.info("-none: " + privilegeName);
            removedPrivilegeNames.add(privilegeName);
        }
        try {
            this.logger.info("Make the actual changes");
            AccessControlUtil.replaceAccessControlEntry((Session)jcrSession, (String)resourcePath, (Principal)principal, (String[])grantedPrivilegeNames.toArray(new String[grantedPrivilegeNames.size()]), (String[])deniedPrivilegeNames.toArray(new String[deniedPrivilegeNames.size()]), (String[])removedPrivilegeNames.toArray(new String[removedPrivilegeNames.size()]), (String)order);
            if (jcrSession.hasPendingChanges()) {
                jcrSession.save();
            }
        }
        catch (RepositoryException re) {
            return false;
        }
        return true;
    }
}

