/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.privilegemanager;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.api.JackrabbitWorkspace;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateCostumePrivilegeServlet
extends HttpServlet {
    public static final String NAME = "name";
    public static final String PRIVILEGE = "privilege";
    private Logger logger = LoggerFactory.getLogger(CreateCostumePrivilegeServlet.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logger.info("Servlet Create Costume Privilege called ......");
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        XStream xstream = null;
        String xmlConfig = null;
        boolean modified = false;
        try {
            try {
                xstream = new XStream();
                session = (SessionImpl)rep.login((Credentials)new SimpleCredentials(request.getParameter("adminId"), request.getParameter("adminPassword").toCharArray()));
                String name = request.getParameter(NAME);
                String[] privileges = request.getParameterValues(PRIVILEGE);
                if (privileges == null) {
                    privileges = new String[]{};
                }
                this.createCostumePrivilege(session, name, privileges);
                modified = true;
                xmlConfig = xstream.toXML((Object)modified);
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
            }
            catch (RepositoryException e) {
                this.logger.error("Error repository ex " + (Object)((Object)e));
                xmlConfig = xstream.toXML((Object)modified);
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
                if (session != null) {
                    session.logout();
                }
                out.close();
                out.flush();
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
            out.close();
            out.flush();
        }
    }

    private void createCostumePrivilege(SessionImpl session, String name, String[] declaredAggregateNames) throws RepositoryException {
        JackrabbitWorkspace jrws = (JackrabbitWorkspace)session.getWorkspace();
        PrivilegeManager privMgr = null;
        try {
            privMgr = jrws.getPrivilegeManager();
        }
        catch (RepositoryException e) {
            this.logger.error("Error creating the costume privilege " + name);
        }
        this.logger.info("getRegisteredPrivileges ");
        Privilege[] privileges = privMgr.getRegisteredPrivileges();
        int i = 0;
        while (i < privileges.length) {
            this.logger.info(privileges[i].getName());
            ++i;
        }
        this.logger.info("getPrivilege " + name);
        try {
            Privilege priv = privMgr.getPrivilege(name);
            this.logger.info("Privilege already exists: " + priv.getName());
        }
        catch (AccessControlException e) {
            this.logger.error("catch " + (Object)((Object)e));
            try {
                privMgr.registerPrivilege(name, false, declaredAggregateNames);
            }
            catch (Exception e1) {
                this.logger.error("Error registering privilege " + name + " - " + e1);
            }
        }
        this.logger.info("getRegisteredPrivileges 2 ");
        Privilege[] privileges1 = privMgr.getRegisteredPrivileges();
        int i2 = 0;
        while (i2 < privileges1.length) {
            this.logger.info(privileges1[i2].getName());
            ++i2;
        }
    }
}

