package org.apache.jackrabbit.j2ee.workspacemanager;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRExternalFile;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRExternalImage;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRExternalPDFFile;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRExternalUrl;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRGCubeItem;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRQuery;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRReport;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRReportTemplate;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRTimeSeries;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRWorkflowReport;
import org.apache.jackrabbit.j2ee.workspacemanager.items.gcube.JCRDocument;
import org.apache.jackrabbit.j2ee.workspacemanager.items.gcube.JCRImageDocument;
import org.apache.jackrabbit.j2ee.workspacemanager.items.gcube.JCRMetadata;
import org.apache.jackrabbit.j2ee.workspacemanager.items.gcube.JCRPDFDocument;
import org.apache.jackrabbit.j2ee.workspacemanager.items.gcube.JCRUrlDocument;
import org.apache.jackrabbit.j2ee.workspacemanager.search.JCRSearchFolder;
import org.apache.jackrabbit.j2ee.workspacemanager.search.JCRSearchFolderItem;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.SearchItemDelegate;
import org.gcube.common.homelibary.model.items.type.PrimaryNodeType;

import com.thoughtworks.xstream.XStream;

public class NodeManager {

	Node node;
	String login;
	XStream xstream;

	public NodeManager(Node node, String login) throws Exception {	

		this.node = node;
		this.login = login;
	}

	public ItemDelegate getItemDelegate() throws RepositoryException {

		String type = node.getPrimaryNodeType().getName();

		JCRWorkspaceItem item = null;
		
		switch (type) {		
		
		case PrimaryNodeType.NT_WORKSPACE_ROOT: 
		case PrimaryNodeType.NT_FOLDER: 
		case PrimaryNodeType.NT_WORKSPACE_FOLDER_ITEM:
		case PrimaryNodeType.NT_WORKSPACE_FOLDER: 
		case PrimaryNodeType.NT_ROOT_FOLDER_BULK_CREATOR:
		case PrimaryNodeType.NT_ROOT_MESSAGES:
			item = new JCRWorkspaceFolder(node, login);
			break;
			
		case PrimaryNodeType.NT_HOME:
			item = new JCRWorkspaceItem(node, login);
			break;
		case PrimaryNodeType.NT_WORKSPACE_REFERENCE:
			item = new JCRWorkspaceReference(node, login);
			break;
		case PrimaryNodeType.NT_WORKSPACE_SMART_FOLDER:
			item = new JCRWorkspaceSmartFolder(node, login);
			break;
		case PrimaryNodeType.NT_WORKSPACE_SHARED_FOLDER:
			item = new JCRWorkspaceSharedFolder(node,login);
			break;
		case PrimaryNodeType.NT_WORKSPACE_VRE_FOLDER:
			item = new JCRWorkspaceVREFolder(node, login);
			break;
		case PrimaryNodeType.NT_WORKSPACE_FILE:
			item = new JCRExternalFile(node, login);
			break;
		case PrimaryNodeType.NT_WORKSPACE_IMAGE:
			item = new JCRExternalImage(node, login);
			break;
		case PrimaryNodeType.NT_WORKSPACE_PDF_FILE:
			item = new JCRExternalPDFFile(node, login);
			break;
		case PrimaryNodeType.NT_WORKSPACE_URL:
			item = new JCRExternalUrl(node, login);
			break;
		case PrimaryNodeType.NT_GCUBE_ITEM:
			item = new JCRGCubeItem(node, login);
			break;
		case PrimaryNodeType.NT_TRASH_ITEM:
			item = new JCRWorkspaceTrashItem(node, login);
			break;
		case PrimaryNodeType.NT_ITEM_SENT:
			item = new JCRWorkspaceMessage(node, login);
			break;
		case PrimaryNodeType.NT_TIMESERIES_ITEM:
			item = new JCRTimeSeries(node, login);
			break;
		case PrimaryNodeType.NT_QUERY:
			item = new JCRQuery(node, login);
			break;
		case PrimaryNodeType.NT_WORKSPACE_REPORT:
			item = new JCRReport(node, login);
			break;
		case PrimaryNodeType.NT_WORKSPACE_REPORT_TEMPLATE:
			item = new JCRReportTemplate(node, login);
			break;
		case PrimaryNodeType.NT_DOCUMENT_ITEM:
			item = new JCRDocument(node, login);
			break;
		case PrimaryNodeType.NT_IMAGE_DOCUMENT_ITEM:
			item = new JCRImageDocument(node, login);
			break;
		case PrimaryNodeType.NT_PDF_DOCUMENT_ITEM:
			item = new JCRPDFDocument(node, login);
			break;
		case PrimaryNodeType.NT_URL_DOCUMENT_ITEM:
			item = new JCRUrlDocument(node, login);
			break;
		case PrimaryNodeType.NT_METADATA_ITEM:
			item = new JCRMetadata(node, login);
			break;
		case PrimaryNodeType.NT_WORKSPACE_WORKFLOW_REPORT:
			item = new JCRWorkflowReport(node, login);
			break;

		default: 
			throw new RepositoryException("JCR node type unknow");
		}
		
		return item.getItemDelegate();
	}



	public SearchItemDelegate getSearchItem(String itemName) throws RepositoryException {

		String type = node.getPrimaryNodeType().getName();

		if (type.equals(PrimaryNodeType.NT_WORKSPACE_FOLDER) ||
				type.equals(PrimaryNodeType.NT_WORKSPACE_SHARED_FOLDER)) {
			return new JCRSearchFolder(node, itemName).getSearchItemDelegate();
		} else {
			return new JCRSearchFolderItem(node, itemName).getSearchItemDelegate();
		}
	}

}
