/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager;

import com.thoughtworks.xstream.XStream;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.util.WorkspaceItemAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRWorkspaceItem {
    public static final String HL_NAMESPACE = "hl:";
    public static final String JCR_NAMESPACE = "jcr:";
    public static final String REP_NAMESPACE = "rep:";
    private static final String NT_NAMESPACE = "nt:";
    protected static Logger logger = LoggerFactory.getLogger(JCRWorkspaceItem.class);
    protected ItemDelegate item;
    protected XStream xstream = new XStream();

    public JCRWorkspaceItem(Node node, String login) throws RepositoryException {
        this.item = new ItemDelegate();
        this.item.setId(node.getIdentifier());
        this.item.setName(Text.unescapeIllegalJcrChars((String)node.getName()));
        this.item.setPath(Text.unescapeIllegalJcrChars((String)node.getPath()));
        this.item.setLocked(node.isLocked());
        this.item.setPrimaryType(node.getPrimaryNodeType().getName());
        try {
            this.item.setParentId(node.getParent().getIdentifier());
            this.item.setParentPath(node.getParent().getPath());
        }
        catch (ItemNotFoundException e) {
            logger.info("Root node doesn't have a parent");
        }
        try {
            if (node.hasProperty(NodeProperty.TITLE.toString())) {
                this.item.setTitle(Text.unescapeIllegalJcrChars((String)node.getProperty(NodeProperty.TITLE.toString()).getString()));
            }
            if (node.hasProperty(NodeProperty.DESCRIPTION.toString())) {
                this.item.setDescription(node.getProperty(NodeProperty.DESCRIPTION.toString()).getString());
            }
            if (node.hasProperty(NodeProperty.CREATED.toString())) {
                this.item.setCreationTime(node.getProperty(NodeProperty.CREATED.toString()).getDate());
            }
            if (node.hasProperty(NodeProperty.LAST_ACTION.toString())) {
                this.item.setLastAction(WorkspaceItemAction.valueOf((String)node.getProperty(NodeProperty.LAST_ACTION.toString()).getString()));
            }
            if (node.hasProperty(NodeProperty.LAST_MODIFIED_BY.toString())) {
                this.item.setLastModifiedBy(node.getProperty(NodeProperty.LAST_MODIFIED_BY.toString()).getString());
            }
            if (node.hasProperty(NodeProperty.LAST_MODIFIED.toString())) {
                this.item.setLastModificationTime(node.getProperty(NodeProperty.LAST_MODIFIED.toString()).getDate());
            }
            try {
                this.item.setMetadata(this.getMetadata(node));
            }
            catch (Exception e) {
                logger.info("Error setting metadata");
            }
            this.item.setLocked(node.isLocked());
        }
        catch (Exception e) {
            logger.error("error setting basic properties on node: " + node.getPath(), (Throwable)e);
        }
        try {
            this.item.setProperties(new HashMap());
        }
        catch (Exception e) {
            logger.error("error setting metadata", (Throwable)e);
        }
        String idSharedFolder = null;
        String idTrashFolder = null;
        String idHiddenFolder = null;
        try {
            String ids = this.getIds(node, null, null, null);
            String[] split = ids.split(",");
            idSharedFolder = split[0];
            idTrashFolder = split[1];
            idHiddenFolder = split[2];
            if (!idSharedFolder.equals("null")) {
                this.item.setShared(true);
                this.item.getProperties().put(NodeProperty.SHARED_ROOT_ID, idSharedFolder);
                try {
                    Session session = node.getSession();
                    Node sharedNode = session.getNodeByIdentifier(idSharedFolder);
                    Map users = this.getMembers(sharedNode);
                    this.item.getProperties().put(NodeProperty.USERS, this.xstream.toXML((Object)users));
                }
                catch (Exception e) {
                    logger.info(" Error setting user of shared folder");
                }
            } else {
                this.item.setShared(false);
            }
            if (!idTrashFolder.equals("null")) {
                this.item.setTrashed(true);
            } else {
                this.item.setTrashed(false);
            }
            if (!idHiddenFolder.equals("null")) {
                this.item.setHidden(true);
            } else {
                this.item.setHidden(false);
            }
        }
        catch (Exception e) {
            logger.error("error setting isShared");
        }
        try {
            this.item.setOwner(node.getProperty(NodeProperty.PORTAL_LOGIN.toString()).getString());
        }
        catch (Exception e) {
            try {
                Node nodeOwner = node.getNode(NodeProperty.OWNER.toString());
                this.item.setOwner(nodeOwner.getProperty(NodeProperty.PORTAL_LOGIN.toString()).getString());
            }
            catch (PathNotFoundException e1) {
                logger.error("error setting owner");
            }
        }
    }

    public String getIds(Node node, String idSharedFolder, String idTrashFolder, String idHiddenFolder) throws RepositoryException {
        if (this.isRoot(node)) {
            return idSharedFolder + "," + idTrashFolder + "," + idHiddenFolder;
        }
        if (node.getPrimaryNodeType().getName().equals("nthl:workspaceSharedItem")) {
            idSharedFolder = node.getIdentifier();
        } else if (node.getPrimaryNodeType().getName().equals("nthl:trashItem")) {
            idTrashFolder = node.getIdentifier();
        } else if (node.hasProperty(NodeProperty.HIDDEN.toString()) && node.getProperty(NodeProperty.HIDDEN.toString()).getBoolean()) {
            idHiddenFolder = node.getIdentifier();
        }
        return this.getIds(node.getParent(), idSharedFolder, idTrashFolder, idHiddenFolder);
    }

    private Map<String, String> getMembers(Node node) throws RepositoryException {
        HashMap<String, String> list = new HashMap<String, String>();
        try {
            Node usersNode = node.getNode(NodeProperty.USERS.toString());
            PropertyIterator iterator = usersNode.getProperties();
            while (iterator.hasNext()) {
                Property property = iterator.nextProperty();
                String key = property.getName();
                String value = property.getString();
                if (key.startsWith(JCR_NAMESPACE) || key.startsWith(HL_NAMESPACE) || key.startsWith(NT_NAMESPACE)) continue;
                list.put(key, value);
            }
        }
        catch (RepositoryException e) {
            logger.error("error getting members node");
            throw new RepositoryException(e.getMessage());
        }
        return list;
    }

    public ItemDelegate getItemDelegate() {
        return this.item;
    }

    public String getIdSharedFolder(Node node) throws RepositoryException {
        if (node.getPrimaryNodeType().getName().equals("nthl:workspaceSharedItem")) {
            return node.getIdentifier();
        }
        if (this.isRoot(node)) {
            return null;
        }
        return this.getIdSharedFolder(node.getParent());
    }

    public String getIdTrashFolder(Node node) throws RepositoryException {
        if (node.getPrimaryNodeType().getName().equals("nthl:trashItem")) {
            return node.getIdentifier();
        }
        if (this.isRoot(node)) {
            return null;
        }
        return this.getIdTrashFolder(node.getParent());
    }

    public boolean isRoot(Node node) throws RepositoryException {
        Node parent = null;
        try {
            parent = node.getParent();
        }
        catch (ItemNotFoundException e) {
            return true;
        }
        return parent == null;
    }

    private Map<String, String> getMetadata(Node itemNode) throws RepositoryException {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Node propertiesNode = itemNode.getNode(NodeProperty.METADATA.toString());
            PropertyIterator iterator = propertiesNode.getProperties();
            while (iterator.hasNext()) {
                Property property = iterator.nextProperty();
                if (property.getName().startsWith(JCR_NAMESPACE)) continue;
                String unescapeName = Text.unescape((String)property.getName());
                map.put(unescapeName, property.getValue().getString());
            }
            return map;
        }
        catch (PathNotFoundException e) {
            if (itemNode != null) {
                try {
                    itemNode.addNode(NodeProperty.METADATA.toString());
                    itemNode.getSession().save();
                }
                catch (Exception e1) {
                    logger.error("Error adding metadata node to " + itemNode.getPath());
                }
            }
        }
        catch (RepositoryException e) {
            throw new RepositoryException(e.getMessage());
        }
        return map;
    }
}

