/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.accessmanager;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.Principal;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveDefaultRead
extends HttpServlet {
    public static final String ABS_PATH = "absPath";
    private Logger logger = LoggerFactory.getLogger(RemoveDefaultRead.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logger.debug("Servlet RemoveDefaultRead Ace called ......");
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        SessionImpl session = null;
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        boolean modified = false;
        XStream xstream = null;
        String xmlConfig = null;
        String adminId = request.getSession().getServletContext().getInitParameter("user");
        char[] adminPass = request.getSession().getServletContext().getInitParameter("pass").toCharArray();
        try {
            session = (SessionImpl)rep.login((Credentials)new SimpleCredentials(adminId, adminPass));
            xstream = new XStream();
            String resourcePath = request.getParameter(ABS_PATH);
            AccessControlManager acMgr = session.getAccessControlManager();
            AccessControlPolicy[] acls = acMgr.getPolicies(resourcePath);
            if (acls.length > 0) {
                AccessControlEntry[] acEntries;
                PrincipalManager pMgr = session.getPrincipalManager();
                Principal everyone = pMgr.getEveryone();
                AccessControlList acList = (AccessControlList)acls[0];
                for (AccessControlEntry acEntry : acEntries = acList.getAccessControlEntries()) {
                    if (!acEntry.getPrincipal().equals(everyone)) continue;
                    acList.removeAccessControlEntry(acEntry);
                    session.save();
                    modified = true;
                }
                session.save();
            }
            xmlConfig = xstream.toXML((Object)modified);
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        catch (RepositoryException e) {
            modified = false;
            xmlConfig = xstream.toXML((Object)e);
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
            out.println(xmlConfig);
        }
        finally {
            if (session != null) {
                session.logout();
            }
            out.close();
            out.flush();
        }
    }
}

