/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.lock;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.NodeManager;
import org.apache.jackrabbit.j2ee.workspacemanager.SessionManager;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSession
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(TestSession.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean flag = false;
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String id = request.getParameter("id");
        String uuid = request.getParameter("uuid");
        String login = request.getParameter("login");
        logger.info("Servlet GetChildrenById called with parameters: [id: " + id + "]");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        XStream xstream = null;
        String xmlConfig = null;
        List children = null;
        SessionManager manager = null;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            manager = SessionManager.getInstance((Repository)rep);
            flag = manager.sessionExists(uuid);
            if (flag) {
                session = manager.getSession(uuid);
                Node node = session.getNodeByIdentifier(id);
                logger.info(node.getPath() + " is locked? " + node.isLocked());
            } else {
                session = manager.newSession(login, request.getParameter("adminId"), request.getParameter("adminPassword").toCharArray());
            }
            children = this.getChildren(session, id, login);
            xmlConfig = xstream.toXML((Object)children);
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        catch (Exception e) {
            logger.error("Error repository ex " + e);
            xmlConfig = xstream.toXML((Object)e.toString());
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        finally {
            if (!flag) {
                manager.releaseSession(uuid);
            }
            out.close();
            out.flush();
        }
    }

    private List<ItemDelegate> getChildren(SessionImpl session, String identifier, String login) throws Exception {
        Node folderNode = session.getNodeByIdentifier(identifier);
        logger.info(folderNode.getPath());
        NodeIterator iterator = folderNode.getNodes();
        ArrayList<ItemDelegate> children = new ArrayList<ItemDelegate>();
        while (iterator.hasNext()) {
            Node node = iterator.nextNode();
            String path = null;
            try {
                path = node.getPath();
                String name = path.substring(path.lastIndexOf(47) + 1);
                if (name.equals("Trash") || name.equals("MySpecialFolders") || name.startsWith("rep:") || name.startsWith("hl:") || name.startsWith(".")) {
                    continue;
                }
            }
            catch (RepositoryException e1) {
                e1.printStackTrace();
            }
            ItemDelegate item = null;
            NodeManager wrap = new NodeManager(node, login);
            try {
                item = wrap.getItemDelegate();
                children.add(item);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return children;
    }
}

