/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.lock;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Repository;
import javax.jcr.lock.LockManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsLocked
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(IsLocked.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String login = request.getParameter("login");
        String sessionId = request.getParameter("uuid");
        String user = request.getParameter("adminId");
        char[] pass = request.getParameter("adminPassword").toCharArray();
        String id = request.getParameter("id");
        logger.info("Servlet IsLocked called with parameters: [ id: " + id + "]");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            try {
                xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
                sessionManager = SessionManager.getInstance((Repository)rep);
                exist = sessionManager.sessionExists(sessionId);
                if (exist) {
                    session = sessionManager.getSession(sessionId);
                } else {
                    session = sessionManager.newSession(login, user, pass);
                    sessionId = session.toString();
                }
                boolean flag = false;
                try {
                    LockManager lockManager = session.getWorkspace().getLockManager();
                    String pathNode = session.getNodeByIdentifier(id).getPath();
                    if (lockManager.isLocked(pathNode)) {
                        flag = true;
                        logger.trace(String.valueOf(pathNode) + " is locked");
                    }
                    xmlConfig = xstream.toXML((Object)flag);
                    response.setContentLength(xmlConfig.length());
                    out.println(xmlConfig);
                }
                catch (Exception e) {
                    logger.error("Error in islock servlet ", (Throwable)e);
                    xmlConfig = xstream.toXML((Object)e.toString());
                    response.setContentLength(xmlConfig.length());
                    out.println(xmlConfig);
                }
            }
            catch (Exception e) {
                logger.error("Error repository ex " + e);
                xmlConfig = xstream.toXML((Object)e.toString());
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
                if (!exist) {
                    sessionManager.releaseSession(sessionId);
                }
                out.close();
                out.flush();
            }
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
            out.flush();
        }
    }
}

