/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.acl;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.accessmanager.AccessControlUtil;
import org.apache.jackrabbit.j2ee.workspacemanager.SessionManager;
import org.apache.jackrabbit.j2ee.workspacemanager.servlets.acl.GetDeniedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDeniedMap
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(GetDeniedMap.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String login = request.getParameter("login");
        String sessionId = request.getParameter("uuid");
        String user = request.getParameter("adminId");
        char[] pass = request.getParameter("adminPassword").toCharArray();
        String absPath = new String(request.getParameter("absPath").getBytes("iso-8859-1"), "UTF-8");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            try {
                xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
                sessionManager = SessionManager.getInstance((Repository)rep);
                exist = sessionManager.sessionExists(sessionId);
                if (exist) {
                    session = sessionManager.getSession(sessionId);
                } else {
                    session = sessionManager.newSession(login, user, pass);
                    sessionId = session.toString();
                }
                try {
                    Map map = this.getDeniedMap(absPath, session);
                    xmlConfig = xstream.toXML((Object)map);
                    response.setContentLength(xmlConfig.length());
                    out.println(xmlConfig);
                }
                catch (Exception e) {
                    logger.error("Error Getting ALC of item: " + absPath, (Throwable)e);
                    xmlConfig = xstream.toXML((Object)e.toString());
                    response.setContentLength(xmlConfig.length());
                    out.println(xmlConfig);
                }
            }
            catch (Exception e) {
                logger.error("Error repository ex " + e);
                xmlConfig = xstream.toXML((Object)e.toString());
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
                if (!exist) {
                    sessionManager.releaseSession(sessionId);
                }
                out.close();
                out.flush();
            }
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
            out.flush();
        }
    }

    public Map<String, List<String>> getDeniedMap(String absPath, SessionImpl session) throws RepositoryException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        LinkedHashMap<Principal, AccessRights> accessMap = new LinkedHashMap<Principal, AccessRights>();
        AccessControlEntry[] entries = this.getDeclaredAccessControlEntries(session, absPath);
        if (entries != null) {
            AccessControlEntry[] accessControlEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                AccessControlEntry ace = accessControlEntryArray[n2];
                ArrayList<String> privilegesList = null;
                Principal principal = ace.getPrincipal();
                AccessRights accessPrivileges = (AccessRights)accessMap.get(principal);
                if (accessPrivileges == null) {
                    accessPrivileges = new AccessRights();
                    accessMap.put(principal, accessPrivileges);
                }
                accessPrivileges.getDenied().addAll(Arrays.asList(ace.getPrivileges()));
                Set deniedPrivileges = accessPrivileges.getDenied();
                for (Privilege priv : deniedPrivileges) {
                    if (privilegesList == null) {
                        privilegesList = new ArrayList<String>();
                    }
                    privilegesList.add(priv.getName());
                }
                map.put(principal.getName(), privilegesList);
                ++n2;
            }
        }
        return map;
    }

    private AccessControlEntry[] getDeclaredAccessControlEntries(SessionImpl session, String absPath) throws RepositoryException {
        AccessControlPolicy[] policies;
        AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
        AccessControlPolicy[] accessControlPolicyArray = policies = accessControlManager.getPolicies(absPath);
        int n = policies.length;
        int n2 = 0;
        while (n2 < n) {
            AccessControlPolicy accessControlPolicy = accessControlPolicyArray[n2];
            if (accessControlPolicy instanceof AccessControlList) {
                AccessControlEntry[] accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries();
                return accessControlEntries;
            }
            ++n2;
        }
        return new AccessControlEntry[0];
    }
}

