/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.post;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.NodeManager;
import org.apache.jackrabbit.j2ee.workspacemanager.SessionManager;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.util.WorkspaceItemAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateReference
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(CreateReference.class);
    private static final long serialVersionUID = 1L;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String login = request.getParameter("login");
        String sessionId = request.getParameter("uuid");
        String user = request.getParameter("adminId");
        char[] pass = request.getParameter("adminPassword").toCharArray();
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            try {
                xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
                sessionManager = SessionManager.getInstance((Repository)rep);
                exist = sessionManager.sessionExists(sessionId);
                if (exist) {
                    session = sessionManager.getSession(sessionId);
                } else {
                    session = sessionManager.newSession(login, user, pass);
                    sessionId = session.toString();
                }
                String srcID = null;
                String destID = null;
                String name = null;
                try {
                    srcID = request.getParameter("srcId");
                    destID = request.getParameter("destId");
                    name = request.getParameter("name");
                    logger.info("Servlet CreateReference called with parameters: [srcID: " + srcID + " - destID: " + destID + "]");
                    ItemDelegate new_item = this.createReference(session, srcID, destID, name, login);
                    xmlConfig = xstream.toXML((Object)new_item);
                    out.println(xmlConfig);
                }
                catch (Exception e) {
                    logger.error("Error creating reference of node id: " + srcID + " - to destination id: " + destID, (Throwable)e);
                    xmlConfig = xstream.toXML((Object)e.toString());
                    out.println(xmlConfig);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Error repository ex " + e.getMessage());
                xmlConfig = xstream.toXML((Object)e.toString());
                out.println(xmlConfig);
                if (!exist) {
                    sessionManager.releaseSession(sessionId);
                }
                out.close();
            }
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
        }
    }

    private ItemDelegate createReference(SessionImpl session, String srcID, String destID, String name, String login) {
        ItemDelegate item = null;
        Node srcNode = null;
        Node destNode = null;
        try {
            srcNode = session.getNodeByIdentifier(srcID);
            srcNode.addMixin("mix:referenceable");
            destNode = session.getNodeByIdentifier(destID);
            Node link = destNode.addNode(name, "nthl:workspaceReference");
            link.setProperty(NodeProperty.REFERENCE.toString(), srcNode);
            link.setProperty(NodeProperty.PORTAL_LOGIN.toString(), login);
            link.setProperty(NodeProperty.TITLE.toString(), srcNode.getName());
            link.setProperty(NodeProperty.LAST_ACTION.toString(), WorkspaceItemAction.CREATED.toString());
            session.save();
            logger.info("References to " + srcNode.getPath() + ":");
            for (Property reference : JcrUtils.getReferences((Node)srcNode)) {
                logger.info("- " + reference.getPath().replace(NodeProperty.REFERENCE.toString(), ""));
            }
            NodeManager wrap = new NodeManager(link, login);
            item = wrap.getItemDelegate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return item;
    }
}

