/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.usermanager;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateGroupServlet
extends HttpServlet {
    public static final String MEMBER = "member";
    public static final String MEMBER_DELETE = "memberToDelete";
    public static final String GROUP_NAME = "groupName";
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(UpdateGroupServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logger.info("Servlet UpdateGroupServlet called ......");
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        boolean modified = false;
        XStream xstream = null;
        String xmlConfig = null;
        try {
            try {
                xstream = new XStream();
                session = (SessionImpl)rep.login((Credentials)new SimpleCredentials(request.getParameter("adminId"), request.getParameter("adminPassword").toCharArray()));
                String groupName = request.getParameter(GROUP_NAME);
                String[] membersToAdd = request.getParameterValues(MEMBER);
                String[] membersToDelete = request.getParameterValues(MEMBER_DELETE);
                UserManager userManager = session.getUserManager();
                Authorizable authorizable = userManager.getAuthorizable(groupName);
                if (authorizable.isGroup()) {
                    Authorizable memberAuthorizable;
                    String member;
                    int n;
                    int n2;
                    String[] stringArray;
                    Group group = (Group)authorizable;
                    if (membersToAdd != null) {
                        stringArray = membersToAdd;
                        n2 = membersToAdd.length;
                        n = 0;
                        while (n < n2) {
                            member = stringArray[n];
                            memberAuthorizable = this.getAuthorizable(member, userManager);
                            if (memberAuthorizable != null) {
                                group.addMember(memberAuthorizable);
                            }
                            ++n;
                        }
                    }
                    if (membersToDelete != null) {
                        stringArray = membersToDelete;
                        n2 = membersToDelete.length;
                        n = 0;
                        while (n < n2) {
                            member = stringArray[n];
                            memberAuthorizable = this.getAuthorizable(member, userManager);
                            if (memberAuthorizable != null) {
                                group.removeMember(memberAuthorizable);
                            }
                            ++n;
                        }
                    }
                }
                session.save();
                modified = true;
                xmlConfig = xstream.toXML((Object)modified);
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
            }
            catch (RepositoryException e) {
                modified = false;
                xmlConfig = xstream.toXML((Object)modified);
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
                if (session != null) {
                    session.logout();
                }
                out.close();
                out.flush();
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
            out.close();
            out.flush();
        }
    }

    private Authorizable getAuthorizable(String member, UserManager userManager) {
        Authorizable memberAuthorizable = null;
        try {
            memberAuthorizable = userManager.getAuthorizable(member);
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return memberAuthorizable;
    }
}

