/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.lock;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Repository;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSession
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(CreateSession.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String login = request.getParameter("login");
        String user = request.getParameter("adminId");
        String pass = request.getParameter("adminPassword");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionManager sessionManager = null;
        XStream xstream = null;
        String xmlConfig = null;
        try {
            try {
                xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
                sessionManager = SessionManager.getInstance((Repository)rep);
                SessionImpl session = sessionManager.newSession(login, user, pass.toCharArray());
                xmlConfig = xstream.toXML((Object)session.toString());
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
            }
            catch (Exception e) {
                logger.error("Error repository ex " + e);
                xmlConfig = xstream.toXML((Object)e.toString());
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
                out.close();
                out.flush();
            }
        }
        finally {
            out.close();
            out.flush();
        }
    }
}

