/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.accessmanager.privileges;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.session.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CanReadNode
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(CanReadNode.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String login = request.getParameter("login");
        String absPath = new String(request.getParameter("absPath").getBytes("iso-8859-1"), "UTF-8");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        String sessionId = null;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            session = sessionManager.newSession(login);
            sessionId = session.toString();
            Boolean flag = CanReadNode.canReadNode((String)absPath, (Session)session);
            logger.debug("Check if " + session.getUserID() + " can read node " + absPath + "? " + flag);
            xmlConfig = xstream.toXML((Object)flag);
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
            out.close();
            out.flush();
            if (session == null) return;
        }
        catch (Exception e) {
            try {
                logger.error("Error repository ex " + e);
                xmlConfig = xstream.toXML((Object)e.toString());
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
                out.close();
                out.flush();
                if (session == null) return;
            }
            catch (Throwable throwable) {
                if (session == null) throw throwable;
                sessionManager.releaseSession(sessionId);
                throw throwable;
            }
            sessionManager.releaseSession(sessionId);
            return;
        }
        sessionManager.releaseSession(sessionId);
        return;
    }

    public static boolean canReadNode(String absPath, Session session) throws Exception {
        try {
            AccessControlManager accessControlManager = session.getAccessControlManager();
            boolean canRead = accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}read")});
            return canRead;
        }
        catch (RepositoryException e) {
            return false;
        }
    }
}

