/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.rest;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.servlets.rest.Utils;
import org.apache.jackrabbit.j2ee.workspacemanager.session.SessionManager;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.common.homelibrary.util.zip.ZipUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Download
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(Download.class);
    private static final long serialVersionUID = 1L;
    private static final int BYTES_DOWNLOAD = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String absPath = request.getParameter("absPath");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String sessionId = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            session = sessionManager.newSession(request);
            sessionId = session.toString();
            String login = sessionManager.getLogin(sessionId);
            this.download(request, response, xstream, session, absPath, login);
            if (exist) return;
        }
        catch (Exception e) {
            try {
                logger.error("Error repository ex " + e);
                if (exist) return;
            }
            catch (Throwable throwable) {
                if (exist) throw throwable;
                sessionManager.releaseSession(sessionId);
                throw throwable;
            }
            sessionManager.releaseSession(sessionId);
            return;
        }
        sessionManager.releaseSession(sessionId);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(HttpServletRequest request, HttpServletResponse response, XStream xstream, Session session, String absPath, String login) throws Exception {
        logger.info("Servlet Download called with parameters: [absPath: " + absPath + "]");
        Workspace workspace = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome().getWorkspace();
        absPath = Utils.cleanPath((Workspace)workspace, (String)absPath);
        WorkspaceItem item = workspace.getItemByPath(absPath);
        String name = item.getName();
        File file = null;
        InputStream inStream = null;
        OutputStream outStream = null;
        try {
            int lenght;
            String mimeType;
            if (item.isFolder()) {
                WorkspaceFolder folder = (WorkspaceFolder)item;
                name = name + ".zip";
                logger.info("Download zip folder " + name);
                file = ZipUtil.zipFolder((WorkspaceFolder)folder);
                inStream = new FileInputStream(file);
                mimeType = "application/zip";
                lenght = (int)file.length();
            } else {
                logger.info("Download file " + name);
                ExternalFile myfile = (ExternalFile)item;
                inStream = myfile.getData();
                if (inStream.available() == 0) {
                    logger.error("No inpustream for item " + item.getName());
                }
                mimeType = myfile.getMimeType();
                lenght = (int)myfile.getLength();
            }
            response.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", name));
            response.setContentType(mimeType);
            response.setContentLength(lenght);
            int read = -1;
            byte[] buffer = new byte[4096];
            outStream = response.getOutputStream();
            while ((read = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, read);
            }
            outStream.flush();
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }
}

