/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.versioning;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.j2ee.workspacemanager.storage.GCUBEStorage;
import org.gcube.common.homelibary.model.items.accounting.AccountingEntryType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.versioning.JCRVersion;
import org.gcube.common.homelibary.model.versioning.WorkspaceVersion;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRVersioning {
    private static final String ROOT_VERSION = "jcr:rootVersion";
    private static final String FIRST_VERSION = "1.0";
    public static final String WRITE_ALL = "hl:writeAll";
    public static final String ADMINISTRATOR = "jcr:all";
    public static final String READ_ONLY = "jcr:read";
    public static final String WRITE_OWNER = "jcr:write";
    private Logger logger = LoggerFactory.getLogger(JCRVersioning.class);
    private Session session;
    private String login;
    private GCUBEStorage storage;
    private VersionManager versionManager;

    public JCRVersioning(Session session, String login) {
        this.storage = new GCUBEStorage(login);
        this.session = session;
        this.login = login;
        try {
            this.versionManager = session.getWorkspace().getVersionManager();
        }
        catch (UnsupportedRepositoryOperationException e) {
            e.printStackTrace();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    public List<WorkspaceVersion> getVersionHistory(String id) throws InternalErrorException {
        ArrayList<WorkspaceVersion> versions = new ArrayList<WorkspaceVersion>();
        try {
            Node node = this.session.getNodeByIdentifier(id);
            this.logger.trace("Calling Version History for node " + node.getPath());
            Node contentNode = node.getNode(NodeProperty.CONTENT.toString());
            Map versionsUsers = this.getVersionMap(node);
            try {
                VersionHistory history = this.versionManager.getVersionHistory(contentNode.getPath());
                VersionIterator it = history.getAllVersions();
                while (it.hasNext()) {
                    Version version = (Version)it.next();
                    if (version.getName().equals(ROOT_VERSION)) continue;
                    String createdBy = (String)versionsUsers.get(version.getName());
                    WorkspaceVersion jcrVersion = this.getJCRVersion(version.getName(), version.getPath(), version.getCreated(), createdBy, contentNode, false);
                    versions.add(jcrVersion);
                }
            }
            catch (UnsupportedRepositoryOperationException e) {
                if (!this.isVersionable(contentNode)) {
                    String createdBy = contentNode.getParent().getProperty(NodeProperty.PORTAL_LOGIN.toString()).getString();
                    WorkspaceVersion firstVersion = this.convertToVersionable(contentNode, createdBy);
                    versions.add(firstVersion);
                }
            }
            catch (ItemNotFoundException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return versions;
    }

    private boolean isVersionable(Node nodeContent) throws RepositoryException {
        boolean flag = false;
        NodeType[] iterator = nodeContent.getMixinNodeTypes();
        int size = iterator.length;
        for (int i = 0; i <= size - 1; ++i) {
            if (!iterator[i].getName().equals("mix:versionable")) continue;
            flag = true;
        }
        return flag;
    }

    private WorkspaceVersion convertToVersionable(Node contentNode, String createdBy) throws RepositoryException {
        this.logger.info("Non versionable node " + contentNode.getPath() + " - Converting to versionable and create first version...");
        WorkspaceVersion jcrVersion = null;
        if (contentNode != null) {
            try {
                contentNode.addMixin("mix:versionable");
                this.session.save();
                Version firstVersion = this.versionManager.checkin(contentNode.getPath());
                this.logger.info("Created first version " + firstVersion.getName());
                if (!contentNode.isCheckedOut()) {
                    this.logger.info("CHEK OUT NODE " + contentNode.getPath());
                    this.versionManager.checkout(contentNode.getPath());
                }
                Calendar creationDate = contentNode.getParent().getProperty(NodeProperty.CREATED.toString()).getDate();
                jcrVersion = this.getJCRVersion(firstVersion.getName(), firstVersion.getPath(), creationDate, createdBy, contentNode, false);
            }
            catch (RepositoryException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        return jcrVersion;
    }

    private WorkspaceVersion getJCRVersion(String versionID, String versionPath, Calendar creationTime, String createdBy, Node contentNode, boolean getSize) throws PathNotFoundException, RepositoryException {
        JCRVersion jcrVersion = new JCRVersion();
        jcrVersion.setCreated(creationTime);
        jcrVersion.setName(versionID);
        String remotePath = this.getRemotePath(contentNode, versionID, versionPath);
        jcrVersion.setRemotePath(remotePath);
        jcrVersion.setUser(createdBy);
        jcrVersion.setCurrentVersion(this.isCurrentVersion(versionID, contentNode.getPath()));
        if (getSize) {
            long size = this.storage.getRemoteFileSize(remotePath);
            jcrVersion.setSize(size);
        }
        this.logger.trace(jcrVersion.toString());
        return jcrVersion;
    }

    private boolean isCurrentVersion(String versionID, String path) throws UnsupportedRepositoryOperationException, RepositoryException {
        String baseVersion = this.versionManager.getBaseVersion(path).getName();
        return versionID.equals(baseVersion);
    }

    private Map<String, String> getVersionMap(Node node) throws RepositoryException {
        Node accountingNode = node.getNode(NodeProperty.ACCOUNTING.toString());
        HashMap<String, String> map = new HashMap<String, String>();
        String owner = accountingNode.getParent().getProperty(NodeProperty.PORTAL_LOGIN.toString()).getString();
        map.put(FIRST_VERSION, owner);
        NodeIterator iterator = accountingNode.getNodes();
        while (iterator.hasNext()) {
            Node entry = iterator.nextNode();
            AccountingEntryType type = AccountingEntryType.getEnum((String)entry.getPrimaryNodeType().getName());
            if (!type.equals((Object)AccountingEntryType.UPDATE) || !entry.hasProperty(NodeProperty.VERSION.toString())) continue;
            String version = entry.getProperty(NodeProperty.VERSION.toString()).getString();
            String user = entry.getProperty(NodeProperty.USER.toString()).getString();
            map.put(version, user);
        }
        return map;
    }

    public void saveCurrentVersion(String nodeID, String remotePath) throws InternalErrorException {
        this.logger.trace("Calling Save Current Version ");
        try {
            Node rootNode = this.session.getNodeByIdentifier(nodeID);
            Node node = rootNode.getNode(NodeProperty.CONTENT.toString());
            String absPath = node.getPath();
            Version version = this.versionManager.getBaseVersion(absPath);
            this.logger.info("Current version of " + absPath + " is " + version.getCreated().getTime() + " for user " + this.login);
            String newPath = version.getPath();
            this.logger.info("Copy file from " + remotePath + " to " + newPath + " for user " + this.login);
            GCUBEStorage storage = new GCUBEStorage(this.login);
            storage.copyRemoteFile(remotePath, newPath);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void restoreVersion(String nodeID, String remotePath, String versionID) throws InternalErrorException, InsufficientPrivilegesException {
        this.logger.trace("Calling Restore Version " + versionID + " for node ID " + nodeID + " - remote path " + remotePath);
        Version currentVersion = null;
        try {
            Node node = this.session.getNodeByIdentifier(nodeID);
            Node contentNode = node.getNode(NodeProperty.CONTENT.toString());
            String absPath = contentNode.getPath();
            if (this.isCurrentVersion(versionID, absPath)) {
                throw new InternalErrorException("Cannot restore current version.");
            }
            if (!this.versionManager.isCheckedOut(absPath)) {
                this.versionManager.checkout(absPath);
            }
            currentVersion = this.versionManager.getBaseVersion(absPath);
            this.logger.info("Save current version " + currentVersion.getName());
            String oldPath = currentVersion.getPath();
            GCUBEStorage storage = new GCUBEStorage(this.login);
            this.logger.info("Save current version " + currentVersion.getName() + " to remote path " + oldPath + " for user " + this.login);
            this.logger.info("Copy from " + remotePath + " to " + oldPath);
            storage.copyRemoteFile(remotePath, oldPath);
            this.logger.info("** Restore version " + versionID);
            this.versionManager.restore(absPath, versionID, true);
            this.session.save();
            if (!this.versionManager.isCheckedOut(absPath)) {
                this.versionManager.checkout(absPath);
            }
            currentVersion = this.versionManager.getVersionHistory(absPath).getVersion(versionID);
            String versionRestored = currentVersion.getPath();
            this.logger.info("Copy from " + versionRestored + " to " + remotePath);
            InputStream is = storage.getRemoteFile(versionRestored);
            try {
                storage.putStream(is, remotePath);
            }
            catch (IOException | RemoteBackendException e) {
                e.printStackTrace();
            }
            this.logger.info("Get Remote Path by Storage ID " + remotePath);
            contentNode.setProperty(NodeProperty.REMOTE_STORAGE_PATH.toString(), remotePath);
            if (node.hasProperty(NodeProperty.REMOTE_STORAGE_PATH.toString())) {
                node.setProperty(NodeProperty.REMOTE_STORAGE_PATH.toString(), remotePath);
            }
            this.session.save();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void removeAllVersions(String nodeID) throws InternalErrorException, InsufficientPrivilegesException {
        try {
            Node rootNode = this.session.getNodeByIdentifier(nodeID);
            Node node = rootNode.getNode(NodeProperty.CONTENT.toString());
            Version currentVersion = this.versionManager.getBaseVersion(node.getPath());
            String path = currentVersion.getPath();
            String basePath = path.substring(0, path.lastIndexOf(47) + 1);
            this.storage.removeRemoteFolder(basePath);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void removeVersion(String nodeID, String versionID) throws InternalErrorException, InsufficientPrivilegesException {
        this.logger.trace("Calling Remove Version History Servlet");
        try {
            Node rootNode = this.session.getNodeByIdentifier(nodeID);
            Node node = rootNode.getNode(NodeProperty.CONTENT.toString());
            String absPath = node.getPath();
            if (this.isCurrentVersion(versionID, absPath)) {
                throw new InternalErrorException("Cannot remove current version.");
            }
            VersionHistory history = this.versionManager.getVersionHistory(absPath);
            Version oldVersion = history.getVersion(versionID);
            String oldPath = oldVersion.getPath();
            GCUBEStorage storage = new GCUBEStorage(this.login);
            this.logger.info("Remove remote path " + oldPath + " refering to version created on " + oldVersion.getCreated().getTime() + " for user " + this.login);
            storage.removeRemoteFile(oldPath);
            if (this.versionManager.isCheckedOut(absPath)) {
                this.versionManager.checkout(absPath);
            }
            history.removeVersion(versionID);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceVersion getLastVersion(String nodeID) throws InternalErrorException, RepositoryException {
        WorkspaceVersion currentVersion = null;
        Node node = null;
        Node contentNode = null;
        try {
            node = this.session.getNodeByIdentifier(nodeID);
            Map versionsUsers = this.getVersionMap(node);
            contentNode = node.getNode(NodeProperty.CONTENT.toString());
            Version version = this.versionManager.getBaseVersion(contentNode.getPath());
            String createdBy = (String)versionsUsers.get(version.getName());
            currentVersion = this.getJCRVersion(version.getName(), version.getPath(), version.getCreated(), createdBy, contentNode, true);
        }
        catch (UnsupportedRepositoryOperationException e) {
            try {
                String createdBy = contentNode.getParent().getProperty(NodeProperty.PORTAL_LOGIN.toString()).getString();
                currentVersion = this.convertToVersionable(contentNode, createdBy);
            }
            catch (RepositoryException e1) {
                throw new InternalErrorException((Throwable)e);
            }
        }
        this.logger.info("Current version of " + contentNode.getPath() + " is " + currentVersion.getName());
        return currentVersion;
    }

    public WorkspaceVersion getVersion(String nodeID, String versionID) throws InternalErrorException {
        this.logger.info("Get version " + versionID + " of node " + nodeID);
        WorkspaceVersion myVersion = null;
        try {
            Node node = this.session.getNodeByIdentifier(nodeID);
            Node contentNode = node.getNode(NodeProperty.CONTENT.toString());
            Map versionsUsers = this.getVersionMap(node);
            VersionHistory history = this.versionManager.getVersionHistory(contentNode.getPath());
            Version version = history.getVersion(versionID);
            String createdBy = (String)versionsUsers.get(versionID);
            myVersion = this.getJCRVersion(versionID, version.getPath(), version.getCreated(), createdBy, contentNode, true);
            this.logger.info("Version " + version.getName() + " of " + contentNode.getPath());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return myVersion;
    }

    public InputStream downloadVersion(String id, String versionID) throws InternalErrorException, IOException {
        InputStream inputStream = null;
        try {
            Node rootNode = this.session.getNodeByIdentifier(id);
            Node node = rootNode.getNode(NodeProperty.CONTENT.toString());
            VersionManager vm = this.versionManager;
            Version version = vm.getVersionHistory(node.getPath()).getVersion(versionID);
            this.logger.info("Get Version " + version.getName());
            String remotePath = this.getRemotePath(node, version.getName(), version.getPath());
            GCUBEStorage storage = new GCUBEStorage(this.login);
            inputStream = storage.getRemoteFile(remotePath);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return inputStream;
    }

    private String getRemotePath(Node node, String versionID, String versionPath) throws UnsupportedRepositoryOperationException, RepositoryException {
        VersionManager vm = this.versionManager;
        this.logger.debug("Get the remotePath of node " + node.getPath() + " for version " + versionID);
        Version currentVersion = vm.getBaseVersion(node.getPath());
        String remotePath = null;
        remotePath = currentVersion.getName().equals(versionID) ? node.getProperty(NodeProperty.STORAGE_ID.toString()).getString() : versionPath;
        this.logger.info("Remote Path version of " + node.getPath() + " is " + remotePath);
        return remotePath;
    }
}

