/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Properties;
import javax.jcr.Repository;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.jackrabbit.j2ee.BootstrapConfig;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.ServletExceptionWithCause;
import org.apache.jackrabbit.rmi.repository.URLRemoteRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class RepositoryAccessServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(RepositoryAccessServlet.class);
    public static final String INIT_PARAM_BOOTSTRAP_CONFIG = "bootstrap-config";
    private static final String CTX_PARAM_THIS = "repository.access.servlet";
    static String bootstrapOverride = null;
    private BootstrapConfig config;
    private InitialContext jndiContext;
    private String repositoryContextAttributeName;
    private Repository repository;

    public void init() throws ServletException {
        if (this.getServletContext().getAttribute("repository.access.servlet") != null) {
            throw new ServletException("Only one repository access servlet allowed per web-app.");
        }
        this.getServletContext().setAttribute("repository.access.servlet", (Object)this);
        this.repositoryContextAttributeName = this.getServletConfig().getInitParameter("repository.context.attribute.name");
        log.info("RepositoryAccessServlet initialized.");
    }

    public static RepositoryAccessServlet getInstance(ServletContext ctx) {
        RepositoryAccessServlet instance = (RepositoryAccessServlet)ctx.getAttribute("repository.access.servlet");
        if (instance == null) {
            throw new IllegalStateException("No RepositoryAccessServlet instance in ServletContext, RepositoryAccessServlet servlet not initialized?");
        }
        return instance;
    }

    private BootstrapConfig getConfig() throws ServletException {
        if (this.config == null) {
            Properties bootstrapProps = new Properties();
            String bstrp = bootstrapOverride;
            if (bstrp == null) {
                bstrp = this.getServletConfig().getInitParameter("bootstrap-config");
            }
            if (bstrp != null) {
                File file;
                InputStream in = this.getServletContext().getResourceAsStream(bstrp);
                if (in == null && (file = new File(bstrp)).canRead()) {
                    try {
                        in = new FileInputStream(file);
                    }
                    catch (FileNotFoundException e) {
                        throw new ServletExceptionWithCause("Bootstrap configuration not found: " + bstrp, (Throwable)e);
                    }
                }
                if (in != null) {
                    try {
                        try {
                            bootstrapProps.load(in);
                        }
                        catch (IOException e) {
                            throw new ServletExceptionWithCause("Bootstrap configuration failure: " + bstrp, (Throwable)e);
                        }
                    }
                    finally {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            BootstrapConfig tmpConfig = new BootstrapConfig();
            tmpConfig.init(this.getServletConfig());
            tmpConfig.init(bootstrapProps);
            tmpConfig.validate();
            if (!tmpConfig.isValid()) {
                throw new ServletException("Repository access configuration is not valid.");
            }
            tmpConfig.logInfos();
            this.config = tmpConfig;
        }
        return this.config;
    }

    private InitialContext getInitialContext() {
        if (this.jndiContext == null && this.config.getJndiConfig().enabled()) {
            try {
                this.jndiContext = new InitialContext(this.config.getJndiConfig().getJndiEnv());
            }
            catch (NamingException e) {
                log.error("Create initial context: " + e.toString());
            }
        }
        return this.jndiContext;
    }

    private Repository getRepositoryByJNDI() throws ServletException {
        BootstrapConfig config = this.getConfig();
        if (!config.getJndiConfig().isValid() || !config.getJndiConfig().enabled()) {
            return null;
        }
        String repositoryName = config.getRepositoryName();
        InitialContext ctx = this.getInitialContext();
        if (ctx == null) {
            return null;
        }
        try {
            Repository r = (Repository)ctx.lookup(repositoryName);
            log.info("Acquired repository via JNDI.");
            return r;
        }
        catch (NamingException e) {
            log.error("Error while retrieving repository using JNDI (name={})", (Object)repositoryName, (Object)e);
            return null;
        }
    }

    private Repository getRepositoryByRMI() throws ServletException {
        ClientFactoryDelegater cfd;
        BootstrapConfig config = this.getConfig();
        if (!config.getRmiConfig().isValid() || !config.getRmiConfig().enabled()) {
            return null;
        }
        String rmiURI = config.getRmiConfig().getRmiUri();
        if (rmiURI == null) {
            return null;
        }
        log.info("  trying to retrieve repository using rmi. uri={}", (Object)rmiURI);
        try {
            Class<?> clazz = Class.forName(this.getServerFactoryDelegaterClass());
            cfd = (ClientFactoryDelegater)clazz.newInstance();
        }
        catch (Throwable e) {
            log.error("Unable to locate RMI ClientRepositoryFactory. Is jcr-rmi.jar missing?", e);
            return null;
        }
        try {
            Repository r = cfd.getRepository(rmiURI);
            log.info("Acquired repository via RMI.");
            return r;
        }
        catch (Exception e) {
            log.error("Error while retrieving repository using RMI: {}", (Object)rmiURI, (Object)e);
            return null;
        }
    }

    protected Repository getRepositoryByContextAttribute() {
        Repository result = null;
        if (this.repositoryContextAttributeName != null) {
            result = (Repository)this.getServletContext().getAttribute(this.repositoryContextAttributeName);
            if (log.isDebugEnabled()) {
                if (result != null) {
                    log.debug("Got Repository from ServletContext attribute '{}'", (Object)this.repositoryContextAttributeName);
                } else {
                    log.debug("ServletContext attribute '{}' does not provide a Repository", (Object)this.repositoryContextAttributeName);
                }
            }
        }
        return result;
    }

    protected String getServerFactoryDelegaterClass() {
        return String.valueOf(this.getClass().getName()) + "$RMIClientFactoryDelegater";
    }

    public Repository getRepository() {
        try {
            if (this.repository == null) {
                this.repository = this.getRepositoryByContextAttribute();
            }
            if (this.repository == null) {
                this.repository = this.getRepositoryByJNDI();
            }
            if (this.repository == null) {
                this.repository = this.getRepositoryByRMI();
            }
            if (this.repository == null) {
                throw new ServletException("N/A");
            }
            return this.repository;
        }
        catch (ServletException e) {
            throw new IllegalStateException("The repository is not available. Please check RepositoryAccessServlet configuration in web.xml.", e);
        }
    }

    private static Repository getMyRepository() {
        URLRemoteRepository repository = null;
        String url = "http://node11.d.d4science.research-infrastructures.eu:8080/home-library-webapp";
        try {
            repository = new URLRemoteRepository(String.valueOf(url) + "/rmi");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return repository;
    }

    public static Repository getRepository(ServletContext ctx) {
        return RepositoryAccessServlet.getInstance((ServletContext)ctx).getRepository();
    }

    public BootstrapConfig getBootstrapConfig() {
        return this.config;
    }
}

