/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.privilegemanager;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.SimpleCredentials;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.privilegemanager.JCRPrivilegeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRegisteredPrivileges
extends HttpServlet {
    private Logger logger = LoggerFactory.getLogger(GetRegisteredPrivileges.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logger.debug("Servlet get Registered Privileges servlet called ......");
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        XStream xstream = null;
        String xmlConfig = null;
        String adminId = request.getSession().getServletContext().getInitParameter("user");
        char[] adminPass = request.getSession().getServletContext().getInitParameter("pass").toCharArray();
        try {
            try {
                session = (SessionImpl)rep.login((Credentials)new SimpleCredentials(adminId, adminPass));
                xstream = new XStream();
                JCRPrivilegeManager privManager = new JCRPrivilegeManager(session);
                List privileges = privManager.getRegisteredPrivileges();
                xmlConfig = xstream.toXML((Object)privileges);
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
            }
            catch (Exception e) {
                this.logger.error("Error repository ex " + e);
                xmlConfig = xstream.toXML((Object)e.getMessage());
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
                if (session != null) {
                    session.logout();
                }
                out.close();
                out.flush();
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
            out.close();
            out.flush();
        }
    }
}

