/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.rest;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.Principal;
import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.security.Privilege;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.accessmanager.AccessControlUtil;
import org.apache.jackrabbit.j2ee.workspacemanager.servlets.rest.Utils;
import org.apache.jackrabbit.j2ee.workspacemanager.session.SessionManager;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateFolder
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(CreateFolder.class);
    private static final long serialVersionUID = 1L;
    private static final String PORTAL_LOGIN = "hl:portalLogin";
    private static final String OWNER_NODE = "hl:owner";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block15: {
            response.setContentType("text/html; charset=UTF-8");
            PrintWriter out = response.getWriter();
            String sessionId = request.getParameter("uuid");
            String name = request.getParameter("name");
            String description = request.getParameter("description");
            String parentPath = request.getParameter("parentPath");
            logger.info("Servlet CreateFolder called with parameters: [ name: " + name + " - description: " + description + "- parentPath: " + parentPath + "]");
            Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
            Session session = null;
            XStream xstream = null;
            String xmlConfig = null;
            SessionManager sessionManager = null;
            boolean exist = false;
            boolean canWrite = false;
            try {
                try {
                    xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
                    sessionManager = SessionManager.getInstance((Repository)rep);
                    exist = sessionManager.sessionExists(sessionId);
                    if (exist) {
                        session = sessionManager.getSession(sessionId);
                    } else {
                        session = sessionManager.newSession(request);
                        sessionId = session.toString();
                    }
                    String login = sessionManager.getLogin(sessionId);
                    Node node = session.getNode(parentPath);
                    String owner = null;
                    if (node.hasProperty(PORTAL_LOGIN)) {
                        owner = node.getProperty(PORTAL_LOGIN).getString();
                    } else if (node.hasNode(OWNER_NODE)) {
                        owner = node.getNode(OWNER_NODE).getProperty(PORTAL_LOGIN).getString();
                    }
                    if (owner.equals(login)) {
                        canWrite = true;
                    } else {
                        PrincipalManager principalManager = AccessControlUtil.getPrincipalManager((Session)session);
                        Principal principal = principalManager.getPrincipal(login);
                        JackrabbitAccessControlManager jacm = (JackrabbitAccessControlManager)session.getAccessControlManager();
                        HashSet<Principal> principals = new HashSet<Principal>();
                        principals.add(principal);
                        logger.info("Check if " + principal.getName() + " can add nodes to " + parentPath);
                        canWrite = jacm.hasPrivileges(parentPath, principals, new Privilege[]{jacm.privilegeFromName("{http://www.jcp.org/jcr/1.0}addChildNodes")});
                        logger.info("Can " + principal.getName() + " add nodes to " + parentPath + "? " + canWrite);
                    }
                    if (canWrite) {
                        Workspace workspace = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome().getWorkspace();
                        parentPath = Utils.cleanPath((Workspace)workspace, (String)parentPath);
                        WorkspaceItem folder = workspace.getItemByPath(parentPath);
                        WorkspaceFolder item = workspace.createFolder(name, description, folder.getId());
                        xmlConfig = xstream.toXML((Object)item.getPath());
                        break block15;
                    }
                    xmlConfig = xstream.toXML((Object)"No privilege to create folder");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("Error repository ex " + e.getMessage());
                    xmlConfig = xstream.toXML((Object)e.toString());
                    response.setContentLength(xmlConfig.length());
                    out.println(xmlConfig);
                    response.setContentLength(xmlConfig.length());
                    out.println(xmlConfig);
                    if (!exist) {
                        sessionManager.releaseSession(sessionId);
                    }
                    out.close();
                    out.flush();
                }
            }
            finally {
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
                if (!exist) {
                    sessionManager.releaseSession(sessionId);
                }
                out.close();
                out.flush();
            }
        }
    }
}

