/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.rest;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.servlets.rest.Utils;
import org.apache.jackrabbit.j2ee.workspacemanager.session.SessionManager;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.util.zip.UnzipUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Unzip
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(Unzip.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String sessionId = request.getParameter("uuid");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            try {
                xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
                sessionManager = SessionManager.getInstance((Repository)rep);
                exist = sessionManager.sessionExists(sessionId);
                if (exist) {
                    session = sessionManager.getSession(sessionId);
                } else {
                    session = sessionManager.newSession(request);
                    sessionId = session.toString();
                }
                this.unzip(request, response, out, xstream, session);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Error repository ex " + e.getMessage());
                xmlConfig = xstream.toXML((Object)e.toString());
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
                if (!exist) {
                    sessionManager.releaseSession(sessionId);
                }
                out.close();
                out.flush();
            }
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
            out.flush();
        }
    }

    private void unzip(HttpServletRequest request, HttpServletResponse response, PrintWriter out, XStream xstream, Session session) {
        String name = null;
        try {
            name = request.getParameter("name");
            String parentPath = request.getParameter("parentPath");
            boolean replace = Boolean.parseBoolean(request.getParameter("replace"));
            boolean hardReplace = Boolean.parseBoolean(request.getParameter("hardReplace"));
            logger.info("Called REST API Unzip with paremeters: name: " + name + " - " + "parentPath" + ": " + parentPath + " - " + "replace" + ": " + replace + " - " + "hardReplace" + ": " + hardReplace);
            ServletInputStream inputStream = request.getInputStream();
            Workspace workspace = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome().getWorkspace();
            parentPath = Utils.cleanPath((Workspace)workspace, (String)parentPath);
            WorkspaceFolder parent = (WorkspaceFolder)workspace.getItemByPath(parentPath);
            WorkspaceFolder unzipFolder = UnzipUtil.unzip((WorkspaceFolder)parent, (InputStream)inputStream, (String)name, (boolean)replace, (boolean)hardReplace);
            String xmlConfig = xstream.toXML((Object)unzipFolder.getPath());
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        catch (Exception e) {
            logger.error("Error unzipping file: " + name, (Throwable)e);
            String xmlConfig = xstream.toXML((Object)e.toString());
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
    }
}

