/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.Privilege;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    public static final String PATH_SEPARATOR = "/";
    public static final String HOME_FOLDER = "Home";
    public static final String SHARED_FOLDER = "Share";
    public static final String HL_NAMESPACE = "hl:";
    public static final String JCR_NAMESPACE = "jcr:";
    public static final String REP_NAMESPACE = "rep:";
    public static final String NT_WORKSPACE_FOLDER = "nthl:workspaceItem";
    public static final String NT_WORKSPACE_SHARED_FOLDER = "nthl:workspaceSharedItem";
    private static Logger logger = LoggerFactory.getLogger(Utils.class);

    public static String isValidSearchResult(Node node, String login) throws RepositoryException {
        return Utils.isValidSearchResult((Node)node, (String)login, (boolean)true);
    }

    public static String isValidSearchResult(Node node, String login, boolean includeFolder) throws RepositoryException {
        if (!includeFolder && (node.getPrimaryNodeType().getName().equals("nthl:workspaceItem") || node.getPrimaryNodeType().getName().equals("nthl:workspaceSharedItem"))) {
            return null;
        }
        String sharePath = "/Share";
        String userPath = "/Home/" + login;
        try {
            String nodePath = node.getPath();
            if (nodePath.startsWith(userPath)) {
                return node.getProperty(NodeProperty.TITLE.toString()).getString();
            }
            if (nodePath.startsWith(sharePath)) {
                Node sharedNode = (Node)node.getAncestor(2);
                if (node.getPath().equals(sharedNode.getPath())) {
                    Node usersNode = sharedNode.getNode(NodeProperty.USERS.toString());
                    String prop = usersNode.getProperty(login).getValue().getString();
                    String[] value = prop.split("/");
                    return value[1];
                }
                return node.getName();
            }
            return null;
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public static Map<String, List<String>> getMap(List<AccessControlEntry> allEntries) {
        HashMap<String, List<String>> map = null;
        try {
            map = new HashMap<String, List<String>>();
            for (AccessControlEntry entry : allEntries) {
                ArrayList<String> privilegesList = null;
                String key = entry.getPrincipal().getName();
                if (key.equals("everyone")) continue;
                try {
                    privilegesList = (ArrayList<String>)map.get(key);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Privilege[] privileges = entry.getPrivileges();
                for (int i = 0; i < privileges.length; ++i) {
                    if (privilegesList == null) {
                        privilegesList = new ArrayList<String>();
                    }
                    privilegesList.add(privileges[i].getName());
                }
                map.put(entry.getPrincipal().getName(), privilegesList);
            }
        }
        catch (Exception e) {
            logger.error("Impossible to get ACL map");
        }
        return map;
    }
}

