/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.httpproxy.access;

import java.util.Timer;
import java.util.TimerTask;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.access.httpproxy.access.timer.RefreshList;
import org.gcube.data.access.httpproxy.utils.Properties;
import org.gcube.smartgears.ApplicationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainFilterApplicationManager
implements ApplicationManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean enabled = Properties.getInstance().getProperty(Properties.BooleanPropertyType.ENABLED);
    private Timer timer;
    private long timerPeriod = Properties.getInstance().getProperty(Properties.LongPropertyType.DEFAULT_PERIOD) * 1000L;

    public DomainFilterApplicationManager() {
        this.timer = new Timer();
    }

    public void onInit() {
        if (this.enabled) {
            this.logger.debug("Starting IS client timer task");
            this.logger.debug("Timer period " + this.timerPeriod + " ms");
            String scope = ScopeProvider.instance.get();
            this.logger.debug("For scope " + scope);
            this.timer.schedule((TimerTask)new RefreshList(scope), 0L, this.timerPeriod);
        } else {
            this.logger.debug("Domain filter disabled");
        }
    }

    public void onShutdown() {
        this.timer.cancel();
        this.logger.debug("Timer task stopped");
    }
}

