package org.gcube.data.access.httpproxy.base;

import javax.servlet.http.HttpServletRequest;

import org.gcube.data.access.httpproxy.utils.Properties;
import org.gcube.data.access.httpproxy.utils.Utils;
import org.gcube.data.access.httpproxy.utils.labels.BooleanPropertyLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseHTMLModifier implements URIModifier{

	private String 	baseUrl,
					completePath;
	
	private Logger logger;
	private StringBuilder htmlBuilder = null,
						headerContentSubString = null;
	private int headerTagIndex,
				headerEndTaglIndex;
	
	private boolean rewriteURIHTML;
	
	private class BaseURLManagerEnabledLabel implements BooleanPropertyLabel 
	{
		private final String REWRITE_URI_HTML = "rewriteURIHTML";
		
		@Override
		public String getLabel() {

			return REWRITE_URI_HTML;
		}
		
	}
	
	public BaseHTMLModifier ()
	{
		this.logger = LoggerFactory.getLogger(this.getClass());
		
	}
	
	@Override
	public void init(HttpServletRequest request) {
		this.baseUrl = Utils.getBaseUrl(request);
		this.completePath = Utils.getCompletePath(request);
		this.rewriteURIHTML = Properties.getInstance().getProperty(new BaseURLManagerEnabledLabel(),true);
	}
	
	private void parseHTML (String html)
	{
		logger.debug("Parsing HTML...");
		logger.debug("HEAD tag index "+headerTagIndex);
		logger.debug("HEAD tag end index "+headerEndTaglIndex);
		this.htmlBuilder = new StringBuilder(html);
		calculateHeaderTag();
		
		if (this.headerTagIndex != -1 && this.headerEndTaglIndex != -1) this.headerContentSubString = new StringBuilder (htmlBuilder.substring(headerTagIndex+6, headerEndTaglIndex));
		
	}

	private void calculateHeaderTag ()
	{
		headerTagIndex = this.htmlBuilder.indexOf("<head>");
		headerEndTaglIndex = this.htmlBuilder.indexOf("</head>");
	}
	
	private void replaceHeader ()
	{
		htmlBuilder.replace(headerTagIndex+6, headerEndTaglIndex, headerContentSubString.toString());
		calculateHeaderTag();
	}
	
	public void changeBaseUrl ()
	{
		if (this.headerContentSubString != null)
		{
			logger.debug("Changing base URL");
			int baseTagIndex = headerContentSubString.indexOf("<base");
			int baseEndTagIndex = headerContentSubString.indexOf("</base");
			StringBuilder newBaseUrlBuilder = new StringBuilder();
			newBaseUrlBuilder.append("<base href=\"").append(this.baseUrl).append("\">");
			
			if (baseTagIndex == -1)
			{
				headerContentSubString.append(newBaseUrlBuilder);
			}
			else if (baseEndTagIndex == -1)
			{
				baseEndTagIndex = headerContentSubString.indexOf(">", baseEndTagIndex);
				headerContentSubString.replace(baseTagIndex, baseTagIndex+1, newBaseUrlBuilder.toString());
			}
			else
			{
				headerContentSubString.replace(baseTagIndex, baseTagIndex+7, newBaseUrlBuilder.toString());
			}
			
			logger.debug("New Header content");
			logger.debug(headerContentSubString.toString());
			replaceHeader();

		}
	
	}
	
	public void changeScriptBase ()
	{
		this.logger.debug("Changing Script base URL");
		int baseIndex = 0;
		
		while (baseIndex != -1)
		{
			baseIndex = this.headerContentSubString.indexOf("<script",baseIndex);
			this.logger.debug("Base index "+baseIndex);
			
			if (baseIndex !=-1)
			{
				int endTagIndex = this.headerContentSubString.indexOf(">",baseIndex);
				logger.debug("Found script link");
				int sourceIndex = this.headerContentSubString.indexOf("src",baseIndex);
				this.logger.debug("End link tag index "+endTagIndex);
				this.logger.debug("Source attribute index "+sourceIndex);
				
				if (sourceIndex > baseIndex && endTagIndex > sourceIndex)
				{
					int quotesIndex1 = this.headerContentSubString.indexOf("\"",sourceIndex);
					
					if (quotesIndex1 != -1)
					{
						int quotesIndex2 = this.headerContentSubString.indexOf("\"",quotesIndex1+1);
						String url = this.headerContentSubString.substring(quotesIndex1+1, quotesIndex2);
						
						if (!url.startsWith("//")&&url.startsWith("/"))
						{
							StringBuilder cssBase = new StringBuilder(completePath);
							cssBase.append(url);
							this.headerContentSubString.replace(quotesIndex1+1, quotesIndex2, cssBase.toString());
							replaceHeader();
						}
						

					}
				}
				
				

				baseIndex = endTagIndex;
			}
		}
		
		htmlBuilder.replace(headerTagIndex+6, headerEndTaglIndex, headerContentSubString.toString());
	}
	
	public void changeCSSBase ()
	{
		this.logger.debug("Changing CSS base URL");
		int baseIndex = 0;
		
		while (baseIndex != -1)
		{
			baseIndex = this.headerContentSubString.indexOf("<link",baseIndex);
			this.logger.debug("Base index "+baseIndex);
			
			if (baseIndex !=-1)
			{
				int endTagIndex = this.headerContentSubString.indexOf(">",baseIndex);
				int typeIndex = this.headerContentSubString.indexOf("text/css",baseIndex);
				
				if (typeIndex > baseIndex && typeIndex < endTagIndex)
				{
					logger.debug("Found css link");
					int sourceIndex = this.headerContentSubString.indexOf("href",baseIndex);
					this.logger.debug("End link tag index "+endTagIndex);
					this.logger.debug("Source attribute index "+sourceIndex);
					
					if (sourceIndex > baseIndex && endTagIndex > sourceIndex)
					{
						int quotesIndex1 = this.headerContentSubString.indexOf("\"",sourceIndex);
						
						if (quotesIndex1 != -1)
						{
							int quotesIndex2 = this.headerContentSubString.indexOf("\"",quotesIndex1+1);
							String url = this.headerContentSubString.substring(quotesIndex1+1, quotesIndex2);
							
							if (!url.startsWith("//"))
							{
								StringBuilder cssBase = new StringBuilder(completePath);
								cssBase.append(url);
								this.headerContentSubString.replace(quotesIndex1+1, quotesIndex2, cssBase.toString());
								replaceHeader();
							}
							

						}
					}
				}
				

				baseIndex = endTagIndex;
			}
		}
		
		htmlBuilder.replace(headerTagIndex+6, headerEndTaglIndex, headerContentSubString.toString());
	}



	@Override
	public String modify(String body) 
	{

		if (this.rewriteURIHTML)
		{
			parseHTML(body);
			changeBaseUrl();
			changeCSSBase();
			changeScriptBase();
		}
		else this.htmlBuilder = new StringBuilder(body);

		return htmlBuilder.toString();
		
	}


	@Override
	public String getModifiedData() {
	
		return htmlBuilder.toString();
	}



	
}
