package org.gcube.data.access.httpproxy.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {

	private static Logger logger = LoggerFactory.getLogger(Utils.class);
	
	public static URI getAddress (String path,ServletRequest req, boolean setParameters) throws URISyntaxException
	{

		URI response = null;
		
		logger.debug("Path = "+path);
		
		if (path != null)
		{

			
			URIBuilder responseBuilder = new URIBuilder(formatPathString(path));
			
			if (setParameters)
			{
				Map<String, String []> parameters = req.getParameterMap();
				
				Iterator<String> paramsNames = parameters.keySet().iterator();
				
				while (paramsNames.hasNext())
				{
					String name = paramsNames.next();
					logger.debug("Parameter name = "+name);
					String[] values = parameters.get(name);
					
					if (values != null && values.length>0)
					{
						for (String value : values)
						{
							logger.debug("Value = "+value);
							responseBuilder.addParameter(name, value);
						}

					}
					else logger.debug("Invalid parameter");
					

				}
				

			}

			
			response = responseBuilder.build();
			logger.debug("Final address "+response);
			
		}
		else throw new URISyntaxException("NULL", "Invalid path");
		
		
		logger.debug("Final address "+response);
		return response;

	}
	
	private static String formatPathString (String pathString) throws URISyntaxException
	{
		while (pathString.startsWith("/") && pathString.length()>1)
		{
			pathString = pathString.substring(1);
		}
		
		if (pathString.startsWith("https")) throw new URISyntaxException ("https","https schema not accepted");
		
		else if (!pathString.startsWith("http://"))  pathString = "http://"+pathString;
		
		return pathString;
	}
	
	public static String getBaseUrl (HttpServletRequest request)
	{
		StringBuffer requestUrl = request.getRequestURL();
		
		if (requestUrl.indexOf("http://") ==0)  requestUrl.replace(0, 7, "https://");
		
		String pathInfo = request.getPathInfo();
		logger.debug("Request URL "+requestUrl);
		logger.debug("Path info = "+pathInfo);
		StringBuilder baseURLBuilder = new StringBuilder();
		
		if (pathInfo != null)
		{
			int pathIndex = requestUrl.indexOf(pathInfo);
			String basePath = getBasePath(pathInfo);
			logger.debug("Base path "+basePath);
			baseURLBuilder.append(requestUrl.delete(pathIndex, requestUrl.length())).append('/').append(basePath);
		}
		else baseURLBuilder.append(requestUrl);
		
		logger.debug("Base URL "+baseURLBuilder);
		return baseURLBuilder.toString();
		
	}
	
	private static String getBasePath (String pathInfo)
	{
		StringBuilder finalAddressBuilder = new StringBuilder(pathInfo);
		finalAddressBuilder.deleteCharAt(0);
					
		if (finalAddressBuilder.indexOf("http://") == 0) finalAddressBuilder.delete(0, 7);			
		
		int baseUrlSeparator = finalAddressBuilder.indexOf("/");
		String basePath = finalAddressBuilder.toString();
		
		if (baseUrlSeparator != -1)
		{
			basePath = finalAddressBuilder.delete(baseUrlSeparator, finalAddressBuilder.length()).toString();
		}
		return basePath;
	}
	
	public static String getBasePath (HttpServletRequest request)
	{
		
		return getBasePath(request.getPathInfo());
	}
	
	public static String getCompletePath (HttpServletRequest request)
	{
		String pathInfo = request.getPathInfo();
		String basePath = null;
		
		if (pathInfo != null) basePath = getBasePath(pathInfo);
		
		String servletPath = request.getServletPath();
		String contextPath = request.getContextPath();
		logger.debug("Context  = "+contextPath);
		logger.debug("Servlet Path info = "+servletPath);
		logger.debug("Path info = "+basePath);
		return contextPath+servletPath+"/"+basePath;
	}
	
//	private static void setParameters (StringBuilder finalAddressBuilder,Map<String, String[]> parameters)
//	{
//		
//		if (parameters == null || parameters.isEmpty())
//		{
//			logger.debug("No parameters found");
//		}
//		else
//		{
//			logger.debug("Getting parameters");
//			finalAddressBuilder.append("?");
//			Iterator<String> paramsNames = parameters.keySet().iterator();
//			
//			while (paramsNames.hasNext())
//			{
//				String name = paramsNames.next();
//				logger.debug("Parameter name = "+name);
//				String[] values = parameters.get(name);
//				
//				if (values != null && values.length>0)
//				{
//					String value = values[0];
//					logger.debug("Value = "+value);
//					finalAddressBuilder.append(name).append("=");
//					finalAddressBuilder.append(value).append("&");
//				}
//				else logger.debug("Invalid parameter");
//				
//
//			}
//			
//			finalAddressBuilder.deleteCharAt(finalAddressBuilder.length()-1);
//		}
//				
//	}


	public static void main(String[] args) throws URISyntaxException {
		URIBuilder builder = new URIBuilder("https://portlet-proxy-d-d4s.d4science.org/httpproxy/proxy/narra.isti.cnr.it/timeline/narra.js");
		builder.addParameter("prova", "prova1");
		builder.addParameter("prova", "prova2");
		System.out.println(builder.build());
	}
	
}
