/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.httpproxy.base;

import java.io.IOException;
import java.util.Properties;
import org.gcube.data.access.httpproxy.base.NoOpURIModifier;
import org.gcube.data.access.httpproxy.base.URIModifier;
import org.gcube.data.access.httpproxy.utils.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URIModifierFactory {
    private boolean rewriteURI;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Properties uriModifierClasses;
    private final String RESOURCE_NAME = "/urimodifiers";
    private static URIModifierFactory instance;

    private URIModifierFactory() {
        this.rewriteURI = org.gcube.data.access.httpproxy.utils.Properties.getInstance().getProperty(Properties.BooleanPropertyType.REWRITE_URI);
        this.uriModifierClasses = new Properties();
        try {
            this.uriModifierClasses.load(this.getClass().getResourceAsStream("/urimodifiers"));
        }
        catch (IOException e) {
            this.logger.warn("Unable to load uri modifiers list", (Throwable)e);
        }
    }

    public static URIModifierFactory getInstance() {
        if (instance == null) {
            instance = new URIModifierFactory();
        }
        return instance;
    }

    public URIModifier getUriModifier(String contentType) {
        this.logger.debug("Getting the suitable uri modifier");
        String className = this.uriModifierClasses.getProperty(contentType);
        this.logger.debug("Class found " + className);
        NoOpURIModifier uriModifier = null;
        if (this.rewriteURI && className != null) {
            this.logger.debug("Trying to instantiate an URI Modifier");
            try {
                Class<?> uriModifierClass = Class.forName(className);
                uriModifier = (URIModifier)uriModifierClass.newInstance();
            }
            catch (Exception e) {
                this.logger.error("Unable to find a suitable uriModifier");
                this.logger.error("Using no op one");
                uriModifier = new NoOpURIModifier();
            }
        } else {
            this.logger.debug("Class not found or rewrite feature disabled");
            uriModifier = new NoOpURIModifier();
        }
        return uriModifier;
    }
}

