/**
 * 
 */
package org.gcube.spd.spdtools;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;

/**
 * @author Francesco Cerasuolo (francesco.cerasuolo@terradue.com)
 *
 */
@Parameters(commandDescription="Save occurrence from specie(s) into csv file(s)")
public class OccurrenceCommand {
	
	@Parameter(names = "-species", description="A species scientific name", required=true)
	private String species;

	@Parameter(names = "-plugins", variableArity = true, description="A list of valid plugins")
	private List<String> plugins = new ArrayList<String>();

	@Parameter(names = {"-file", "-f"}, description="The csv file to save with occurrences")
	private String fileName = "output.csv";

	@Parameter(names = {"-fromDate", "-from", "-fd"}, description="The date-from occurrences filter (format: ISO8690)", converter = DateConverter.class)
	private Calendar fromDate;

	@Parameter(names = {"-toDate", "-to", "-td"}, description="The date-to occurrences filter (format: ISO8690", converter = DateConverter.class)
	private Calendar toDate;
	
	@Parameter(names = {"-printResults", "-pr"}, description="Print results on terminal")
	private boolean printResults = false;


	/**
	 * @return the species
	 */
	public String getSpecies() {
		return species;
	}
	
	/**
	 * @return the fileName
	 */
	public String getFileName() {
		return fileName;
	}
	
	/**
	 * @return the plugins
	 */
	public List<String> getPlugins() {
		return plugins;
	}

	/**
	 * @return the fromDate
	 */
	public Calendar getFromDate() {
		return fromDate;
	}
	
	/**
	 * @return the toDate
	 */
	public Calendar getToDate() {
		return toDate;
	}

	/**
	 * @return
	 */
	public boolean isPrintResults() {
		return printResults;
	}
}
