/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spd.spdtools;

import java.util.Calendar;
import org.gcube.spd.spdtools.MainCommand;
import org.gcube.spd.spdtools.OccurrenceCommand;
import org.gcube.spd.spdtools.SpdClient;

public class SpdTools {
    public static void main(String[] args) {
        MainCommand mainCommand = new MainCommand(args);
        String scope = mainCommand.getScope();
        if (mainCommand.isHelpCommand() || mainCommand.isError()) {
            if (mainCommand.isOccurrenceCommand()) {
                mainCommand.occurrenceCommandUsage();
            } else if (mainCommand.isListPluginCommand()) {
                mainCommand.listPluginUsage();
            } else {
                mainCommand.usage();
            }
            return;
        }
        if (mainCommand.isListPluginCommand()) {
            SpdClient.listPlugin(scope);
            return;
        }
        if (mainCommand.isOccurrenceCommand()) {
            OccurrenceCommand occurrenceCommand = mainCommand.getOccurrenceCommand();
            String species = occurrenceCommand.getSpecies();
            String fileName = occurrenceCommand.getFileName();
            Calendar fromCal = occurrenceCommand.getFromDate();
            Calendar toCal = occurrenceCommand.getToDate();
            boolean printResults = occurrenceCommand.isPrintResults();
            SpdClient.saveOccurrences(scope, species, fileName, fromCal, toCal, printResults);
            return;
        }
        mainCommand.usage();
    }
}

