/**
 * 
 */
package org.gcube.spd.spdtools;

import java.util.ArrayList;
import java.util.List;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;

/**
 * @author Francesco Cerasuolo (francesco.cerasuolo@terradue.com)
 *
 */
public class MainCommand {

	@Parameter
	private List<String> parameters = new ArrayList<String>();

	@Parameter(names = {"--help", "-help"}, description="Get the usage Syntax", help = true)
	private boolean help;

	@Parameter(names = {"-scope", "-s"}, description="The GCube Scope")
	private String scope = Constants.DEFAULT_SCOPE;
	
	private JCommander jc;
	private ListPluginsCommand listPluginsCommand;
	private OccurrenceCommand occurrenceCommand;
	
	private boolean isError = false;

	/**
	 * 
	 */
	public MainCommand(String[] args) {
		super();
		jc = new JCommander(this);
		jc.setProgramName(Constants.PROGRAM_NAME);
		
		listPluginsCommand = new ListPluginsCommand();
		jc.addCommand(Constants.LIST_PLUGINS_COMMAND_NAME, listPluginsCommand);
		
		occurrenceCommand = new OccurrenceCommand();
		jc.addCommand(Constants.OCCURRENCE_COMMAND_NAME, occurrenceCommand);
		
		try {
			jc.parse(args);
		} catch(ParameterException e) {
			System.out.println("ERROR: "+e.getMessage()+"\n");
			isError = true;
		}
	}
	
	public boolean isHelpCommand() {
		return help;
	}
	
	public void usage() {		
		this.jc.usage();
		System.out.println(".: SpdTools - by Francesco Cerasuolo @ Terradue");
	}

	/**
	 * 
	 */
	public void occurrenceCommandUsage() {
		System.out.println("Usage: "+Constants.PROGRAM_NAME + " occurrence [options]");
		this.jc.usage(Constants.OCCURRENCE_COMMAND_NAME);
	}

	/**
	 * 
	 */
	public void listPluginUsage() {
		this.jc.usage(Constants.LIST_PLUGINS_COMMAND_NAME);
	}

	/**
	 * @return
	 */
	public String getScope() {
		return this.scope;
	}
	
	public boolean isOccurrenceCommand() {
		String command = jc.getParsedCommand();
		return (command!=null && command.contentEquals(Constants.OCCURRENCE_COMMAND_NAME));
	}
	
	public boolean isListPluginCommand() {
		String command = jc.getParsedCommand();
		return (command!=null && command.contentEquals(Constants.LIST_PLUGINS_COMMAND_NAME));
	}
	
	/**
	 * @return the listPluginsCommand
	 */
	public ListPluginsCommand getListPluginsCommand() {
		return listPluginsCommand;
	}
	
	/**
	 * @return the occurrenceCommand
	 */
	public OccurrenceCommand getOccurrenceCommand() {
		return occurrenceCommand;
	}
	
	/**
	 * @return the isError
	 */
	public boolean isError() {
		return isError;
	}
}
