/**
 * 
 */
package org.gcube.spd.spdtools;

import static org.gcube.data.spd.client.plugins.AbstractPlugin.manager;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.TimeUnit;

import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.spd.client.proxies.Manager;
import org.gcube.data.spd.model.PluginDescription;
import org.gcube.data.spd.model.products.OccurrencePoint;
import org.gcube.data.spd.model.products.ResultElement;
import org.gcube.data.spd.model.exceptions.InvalidQueryException;
import org.gcube.data.spd.stubs.exceptions.UnsupportedCapabilityException;
import org.gcube.data.spd.stubs.exceptions.UnsupportedPluginException;
import org.gcube.data.streams.Stream;

import au.com.bytecode.opencsv.CSVWriter;

/**
 * @author Francesco Cerasuolo (francesco.cerasuolo@terradue.com)
 *
 */
public class SpdClient {

	private final static SimpleDateFormat dateFormatter = new SimpleDateFormat(Constants.SPQL_DATE_PATTERN);
	private final static SimpleDateFormat isoDateFormatter = new SimpleDateFormat(Constants.ISO_8601_DATE_PATTERN);

	/**
	 * @return
	 */
	private static Manager getManager(String scope) {
		ScopeProvider.instance.set(scope);
		Manager manager = manager().withTimeout(5, TimeUnit.MINUTES).build();
		return manager;
	}

	/**
	 * @param scope 
	 * 
	 */
	public static void listPlugin(String scope) {
		Manager manager = getManager(scope);

		System.out.println("LIST PLUGINS");

		List<PluginDescription> plugins = manager.getPluginsDescription();
		for (PluginDescription plugin : plugins)
			System.out.println(plugin.getName());          
	}

	public static void saveOccurrences(String scope, String speciesScientificName, 
			String fileName, Calendar fromCal, Calendar toCal, boolean printResults) {
		Manager manager = getManager(scope);
		
		String[] plugins = {"OBIS"};//{ALL_PLUGINS, "Obis", "IRMNG", "NCBI", "WoRMS", "GBIF", "WoRDSS", "ITIS", "CatalogueOfLife"};
		String[] columns = {"decimallongitude", "decimallatitude", "eventDate", "modifiedDate"};
		
//		fromCal = Calendar.getInstance();
//		fromCal.clear();
//		fromCal.set(Calendar.YEAR, 1980);
//		fromCal.set(Calendar.MONTH, 0);
//	    fromCal.set(Calendar.DATE, 1);
//
//		toCal = Calendar.getInstance();
//		toCal.clear();
//		toCal.set(Calendar.YEAR, 2010);
//		toCal.set(Calendar.MONTH, 11);
//	    toCal.set(Calendar.DATE, 1);
		
		for (String plugin : plugins) {
			try {
				System.out.print(plugin + ": ");
				String query = createQuery(speciesScientificName, plugin, fromCal, toCal);
//				String query = "'"+speciesScientificName+"' AS ScientificName"
//						+ (plugin.contentEquals(ALL_PLUGINS) ? "" : " in "+plugin)
//						+" RETURN Occurrence";
//				query = "'Sarda sarda' AS ScientificName WHERE fromDate IS 10/10/2010 RETURN Occurrence";
				System.out.println("\nEXECUTION QUERY: "+query);
				if (printResults)
					System.out.println("#) [<plugin>] (<decimallongitude>,<decimallatitude>); <eventDate>; <modified>");
				Stream<ResultElement> result;
				result = manager.search(query);
	
				CSVWriter writer = new CSVWriter(new FileWriter(fileName), CSVWriter.DEFAULT_SEPARATOR, CSVWriter.NO_QUOTE_CHARACTER);
				
				writer.writeNext(columns);
				int i=0;
				while(result.hasNext()) {
					ResultElement elem = result.next();
					OccurrencePoint op = (OccurrencePoint)elem;
					
					// get data
					double olong = op.getDecimalLongitude();
					double olat = op.getDecimalLatitude();
					Calendar eventCalendar = op.getEventDate();
					Calendar modifiedCalendar = op.getModified();
					
					// converting dates
					String eventDate, modifiedDate;					
					try {
						eventDate = isoDateFormatter.format(eventCalendar.getTime());
					} catch (Exception e) {
						eventDate = "NAN";//""+eventCalendar;
					}
					try {
						modifiedDate = isoDateFormatter.format(modifiedCalendar.getTime());
					} catch (Exception e) {
						modifiedDate = "NAN";//""+modifiedCalendar;
					}
					
					if (printResults)
						System.out.println((i+1)+") [" + op.getProvider() + "] (" + olong + "," + olat + "); " + eventDate+"; " + modifiedDate+"  ");
					++i;
					
					// saving rows on csv file
					String[] entries = {""+olong, ""+olat, eventDate, modifiedDate};
					writer.writeNext(entries);
				}
				writer.close();
				System.out.println(i+" rows found");
				System.out.println("File "+new File(fileName).getAbsoluteFile()+" created.");
	
			} catch (InvalidQueryException e) {
				e.printStackTrace();
			} catch (UnsupportedPluginException e) {
				e.printStackTrace();
			} catch (UnsupportedCapabilityException e) {
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}
	
	private static String createQuery(String speciesScientificName, String plugin, Calendar fromCal, Calendar toCal) {
		StringBuilder query = new StringBuilder();
		
		query.append("SEARCH BY SN '" + speciesScientificName + "'");
		if (!plugin.contentEquals(Constants.ALL_PLUGINS))
			query.append(" IN " + plugin);
		
		boolean printWhere = (fromCal!=null || toCal!=null);
		boolean printAnd = (fromCal!=null && toCal!=null);
		
		if (printWhere)
			query.append(" WHERE");
		
		if (fromCal!=null)
			query.append(" eventDate >= '" + dateFormatter.format(fromCal.getTime()) + "'");
		
		if (printAnd)
			query.append(" AND");
		
		if (toCal!=null)
			query.append(" eventDate <= '" + dateFormatter.format(toCal.getTime()) + "'");
		
		query.append(" RETURN Occurrence");

		return query.toString();
	}


}
