/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.speciesplugin;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.gcube.data.speciesplugin.SpeciesBinder;
import org.gcube.data.speciesplugin.Utils;
import org.gcube.data.speciesplugin.requests.SpeciesRequest;
import org.gcube.data.speciesplugin.utils.SpeciesUpdateScheduler;
import org.gcube.data.tmf.api.Environment;
import org.gcube.data.tmf.api.PluginLifecycle;
import org.gcube.data.tmf.api.Property;

public class SpeciesPlugin
implements PluginLifecycle {
    public String name() {
        return "species-tree-plugin";
    }

    public String description() {
        return "Species Discovery Service plugin";
    }

    public List<Property> properties() {
        return Arrays.asList(new Property("Scientific name", "scientificName", "Sarda Sarda"), new Property("Data Source", "DataSource", "Obis"));
    }

    public SpeciesBinder binder() {
        return new SpeciesBinder();
    }

    public List<String> requestSchemas() {
        String sampleDataSchema = Utils.toSchema(SpeciesRequest.class);
        return Collections.singletonList(sampleDataSchema);
    }

    public boolean isAnchored() {
        return false;
    }

    public void start(Environment environment) throws Exception {
    }

    public void stop(Environment environment) {
        ScheduledThreadPoolExecutor scheduler = SpeciesUpdateScheduler.getInstance();
        scheduler.shutdownNow();
    }
}

