/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.speciesplugin.utils;

import java.util.Hashtable;
import java.util.List;
import javax.xml.namespace.QName;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.model.CommonName;
import org.gcube.data.spd.model.products.TaxonomyItem;
import org.gcube.data.spd.model.util.ElementProperty;
import org.gcube.data.speciesplugin.utils.SpeciesService;
import org.gcube.data.streams.exceptions.StreamSkipSignal;
import org.gcube.data.streams.exceptions.StreamStopSignal;
import org.gcube.data.streams.generators.Generator;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.InnerNode;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Nodes;
import org.gcube.data.trees.data.Tree;

public class SpeciesTreeGenerator
implements Generator<TaxonomyItem, Tree> {
    protected static GCUBELog logger = new GCUBELog(SpeciesTreeGenerator.class);

    public Tree yield(TaxonomyItem element) throws StreamSkipSignal, StreamStopSignal {
        Tree tree = new Tree();
        tree.setAttribute(SpeciesService.SPECIES_SERVICE_ID, element.getId());
        Edge propertiesEdge = this.createProperties(element);
        Edge dwcItemEdge = this.createDwCA(element);
        Edge provenanceItemEdge = this.createProvenance(element);
        tree.add(propertiesEdge);
        tree.add(dwcItemEdge);
        tree.add(provenanceItemEdge);
        return tree;
    }

    private Edge createProvenance(TaxonomyItem item) {
        InnerNode provenanceItem = new InnerNode(new Edge[0]);
        Edge provenanceItemEdge = new Edge(new QName("provenance"), (Node)provenanceItem);
        provenanceItem.add(new Edge[]{Nodes.e((String)"wasDerivedFrom", (Object)item.getCitation()), Nodes.e((String)"wasGeneratedBy", (Object)item.getCredits())});
        return provenanceItemEdge;
    }

    private Edge createDwCA(TaxonomyItem item) {
        Hashtable<String, String> hashTaxa = new Hashtable<String, String>();
        this.getTax(item, hashTaxa);
        String[] name = item.getScientificName().split(" ");
        InnerNode dwcItem = new InnerNode(new Edge[0]);
        Edge dwcItemEdge = new Edge(new QName("dwc"), (Node)dwcItem);
        dwcItem.add(new Edge[]{Nodes.e((String)"scientificNameAuthorship", (Object)item.getAuthor()), Nodes.e((String)"acceptedNameUsageID", (Object)item.getStatus().getRefId()), Nodes.e((String)"taxonomicStatus", (Object)item.getStatus().getStatus()), Nodes.e((String)"taxonRemarks", (Object)item.getStatus().getStatusAsString()), Nodes.e((String)"rightsHolder", (Object)item.getCredits()), Nodes.e((String)"scientificNameID", (Object)item.getLsid()), Nodes.e((String)"modified", (Object)item.getModified()), Nodes.e((String)"taxonRank", (Object)item.getRank()), Nodes.e((String)"scientificName", (Object)item.getScientificName()), Nodes.e((String)"nameAccordingTo", (Object)item.getCitation())});
        String parent = "";
        try {
            parent = item.getParent().getId();
        }
        catch (Exception e) {
            // empty catch block
        }
        dwcItem.add(Nodes.e((String)"parentNameUsageID", (Object)parent));
        String kingdom = "";
        try {
            kingdom = hashTaxa.get("kingdom");
        }
        catch (Exception e) {
            // empty catch block
        }
        dwcItem.add(Nodes.e((String)"kingdom", (Object)kingdom));
        String phylum = "";
        try {
            phylum = hashTaxa.get("phylum");
        }
        catch (Exception e) {
            // empty catch block
        }
        dwcItem.add(Nodes.e((String)"phylum", (Object)phylum));
        String claz = "";
        try {
            claz = hashTaxa.get("class");
        }
        catch (Exception e) {
            // empty catch block
        }
        dwcItem.add(Nodes.e((String)"class", (Object)claz));
        String order = "";
        try {
            order = hashTaxa.get("order");
        }
        catch (Exception e) {
            // empty catch block
        }
        dwcItem.add(Nodes.e((String)"order", (Object)order));
        String family = "";
        try {
            family = hashTaxa.get("family");
        }
        catch (Exception e) {
            // empty catch block
        }
        dwcItem.add(Nodes.e((String)"family", (Object)family));
        String genus = "";
        try {
            genus = hashTaxa.get("genus");
        }
        catch (Exception e) {
            // empty catch block
        }
        dwcItem.add(Nodes.e((String)"genus", (Object)genus));
        String subgenus = "";
        try {
            subgenus = hashTaxa.get("subgenus");
        }
        catch (Exception e) {
            // empty catch block
        }
        dwcItem.add(Nodes.e((String)"subgenus", (Object)subgenus));
        String specificEpithet = "";
        if (name.length > 1) {
            specificEpithet = name[1];
        }
        dwcItem.add(Nodes.e((String)"specificEpithet", (Object)specificEpithet));
        String infraspecificEpithet = "";
        if (name.length > 2) {
            infraspecificEpithet = name[name.length - 1];
        }
        dwcItem.add(Nodes.e((String)"infraspecificEpithet", (Object)infraspecificEpithet));
        String verbatimTaxonRank = "";
        if (name.length > 2) {
            verbatimTaxonRank = name[name.length - 2];
        }
        dwcItem.add(Nodes.e((String)"verbatimTaxonRank", (Object)verbatimTaxonRank));
        InnerNode commonNames = new InnerNode(new Edge[0]);
        List commonNameList = null;
        commonNameList = item.getCommonNames();
        if (commonNameList != null) {
            for (CommonName c : commonNameList) {
                String language = "";
                try {
                    language = c.getLanguage();
                }
                catch (Exception e) {
                    // empty catch block
                }
                String locality = "";
                try {
                    locality = c.getLocality();
                }
                catch (Exception e) {
                    // empty catch block
                }
                String vernacularName = "";
                try {
                    vernacularName = c.getName();
                }
                catch (Exception e) {
                    // empty catch block
                }
                commonNames.add(new Edge[]{Nodes.e((String)"language", (Object)language), Nodes.e((String)"locality", (Object)locality), Nodes.e((String)"vernacularName", (Object)vernacularName)});
                Edge commonNamesEdge = new Edge(new QName("vernacularNames"), (Node)commonNames);
                dwcItem.add(commonNamesEdge);
            }
        }
        return dwcItemEdge;
    }

    private Edge createProperties(TaxonomyItem item) {
        InnerNode properties = new InnerNode(new Edge[0]);
        Edge propertiesEdge = new Edge(new QName("properties"), (Node)properties);
        List listProp = null;
        listProp = item.getProperties();
        if (listProp != null) {
            for (ElementProperty property : listProp) {
                properties.add(Nodes.e((String)"property", (Node)Nodes.n((Edge[])new Edge[]{Nodes.e((String)"key", (Object)property.getName()), Nodes.e((String)"value", (Object)property.getValue())})));
            }
        }
        return propertiesEdge;
    }

    private Hashtable<String, String> getTax(TaxonomyItem item, Hashtable<String, String> taxa) {
        taxa.put(item.getRank().toLowerCase(), item.getScientificName());
        if (item.getParent() != null) {
            this.getTax(item.getParent(), taxa);
        }
        return taxa;
    }
}

