/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.speciesplugin;

import java.io.File;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.gcube.common.clients.exceptions.InvalidRequestException;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.data.speciesplugin.SpeciesSource;
import org.gcube.data.speciesplugin.Utils;
import org.gcube.data.speciesplugin.requests.RequestBinder;
import org.gcube.data.speciesplugin.requests.SpeciesRequest;
import org.gcube.data.speciesplugin.store.SpeciesNeoStore;
import org.gcube.data.speciesplugin.store.SpeciesStore;
import org.gcube.data.speciesplugin.utils.DirDeleter;
import org.gcube.data.speciesplugin.utils.SpeciesService;
import org.gcube.data.speciesplugin.utils.SpeciesUpdateScheduler;
import org.gcube.data.tmf.impl.LifecycleAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SpeciesLifecycle
extends LifecycleAdapter {
    private static final long serialVersionUID = 1L;
    public static final String STORAGE_LOCATION = "store";
    protected static RequestBinder db = new RequestBinder();
    private static Logger log = LoggerFactory.getLogger(SpeciesLifecycle.class);
    private final SpeciesSource source;
    protected List<String> scientificNames;
    protected List<String> datasources;
    protected boolean strictMatch;
    protected long lastUpdate = -1L;
    protected transient ScheduledFuture<?> scheduled;
    protected long updatePeriod;
    protected TimeUnit timeUnit;

    public SpeciesLifecycle(SpeciesSource source, List<String> scientificNames, List<String> datasources, boolean strictMatch, long updatePeriod, TimeUnit timeUnit) {
        this.source = source;
        this.scientificNames = scientificNames;
        this.datasources = datasources;
        this.strictMatch = strictMatch;
        this.updatePeriod = updatePeriod;
        this.timeUnit = timeUnit;
    }

    public void init() throws Exception {
        try {
            log.info("initialising source " + this.source.id());
            File location = this.source.environment().file(STORAGE_LOCATION);
            this.source.store().start(location);
            this.loadCollection();
            this.scheduleRefresh();
        }
        catch (Exception e) {
            log.error("An error occurred initializing the source", (Throwable)e);
            throw new Exception("Error occured during species retrieving", e);
        }
    }

    protected void scheduleRefresh() {
        log.trace("scheduling refresh");
        if (this.updatePeriod <= 0L || this.timeUnit == null) {
            log.trace("scheduleRefresh aborted because of invalid parameters updatePeriod: " + this.updatePeriod + " timeUnit: " + (Object)((Object)this.timeUnit));
            return;
        }
        final GCUBEScope scope = GCUBEScopeManager.DEFAULT.getScope();
        Runnable refresher = new Runnable(){

            @Override
            public void run() {
                log.trace("Refresh task setting scope {}", (Object)scope);
                GCUBEScopeManager.DEFAULT.setScope(scope);
                SpeciesLifecycle.this.refreshCollection();
            }
        };
        long initialDelay = this.calculateInitialRefreshDelay();
        log.trace("scheduling refresh for source " + this.source.id() + " initialDelay: " + initialDelay + " updatePeriod: " + this.updatePeriod + " timeUnit: " + (Object)((Object)this.timeUnit));
        this.scheduled = SpeciesUpdateScheduler.getInstance().scheduleAtFixedRate(refresher, initialDelay, this.updatePeriod, this.timeUnit);
    }

    protected long calculateInitialRefreshDelay() {
        if (this.lastUpdate < 0L) {
            return this.updatePeriod;
        }
        if (this.scheduled != null) {
            return this.updatePeriod;
        }
        long elapsedTime = System.currentTimeMillis() - this.lastUpdate;
        log.trace("elapsed time from the last update: {}", (Object)elapsedTime);
        long expectedDelayMillis = this.timeUnit.toMillis(elapsedTime) - elapsedTime;
        log.trace("expected delay in millis {}", (Object)expectedDelayMillis);
        expectedDelayMillis = expectedDelayMillis < 0L ? 0L : expectedDelayMillis;
        long expectedDelay = this.timeUnit.convert(expectedDelayMillis, TimeUnit.MILLISECONDS);
        return expectedDelay >= 0L ? expectedDelay : this.updatePeriod;
    }

    protected void rescheduleRefresh() {
        this.unscheduleRefresh();
        this.scheduleRefresh();
    }

    protected void refreshCollection() {
        log.trace("starting collection {} refresh", (Object)this.source.id());
        try {
            File tmpFolder = Utils.createTempDirectory();
            log.trace("tmp store location: " + tmpFolder);
            SpeciesNeoStore tmpStore = new SpeciesNeoStore(this.source.id());
            tmpStore.start(tmpFolder);
            log.trace("filling tmp store");
            SpeciesService client = new SpeciesService(tmpStore);
            client.createCollection(this.scientificNames, this.datasources, this.strictMatch);
            log.trace("stopping tmp store");
            tmpStore.stop();
            try {
                TimeUnit.MILLISECONDS.sleep(3000L);
            }
            catch (InterruptedException e) {
                log.warn("could not wait for shutdown to complete", (Throwable)e);
            }
            log.trace("store switch");
            File oldStore = this.source.switchStore(tmpFolder);
            log.trace("scheduling old directory delete ({})", (Object)oldStore);
            SpeciesUpdateScheduler.getInstance().schedule(new DirDeleter(oldStore), 5L, TimeUnit.MINUTES);
            this.lastUpdate = System.currentTimeMillis();
        }
        catch (Exception e) {
            log.error("An error occurred refreshing the collection for source id " + this.source.id(), (Throwable)e);
        }
    }

    protected void loadCollection() throws Exception {
        log.trace("loading collection");
        SpeciesStore store = this.source.store();
        SpeciesService client = new SpeciesService(store);
        client.createCollection(this.scientificNames, this.datasources, this.strictMatch);
    }

    public void reconfigure(Element DOMRequest) throws InvalidRequestException {
        log.info("reconfiguring source " + this.source.id());
        SpeciesRequest request = null;
        try {
            request = db.bind(DOMRequest);
            log.trace("request {}", (Object)request);
            if (request.getRefreshPeriod() > 0 && request.getTimeUnit() != null) {
                this.updatePeriod = request.getRefreshPeriod();
                this.timeUnit = request.getTimeUnit();
                this.rescheduleRefresh();
            }
            boolean refresh = false;
            if (request.getScientificNames().size() != 0) {
                this.scientificNames = request.getScientificNames();
                refresh = true;
            }
            if (request.getDatasources().size() != 0) {
                this.datasources = request.getDatasources();
                refresh = true;
            }
            if (refresh) {
                this.refreshCollection();
                this.rescheduleRefresh();
            }
        }
        catch (Exception e) {
            log.error("Error reconfiguring source " + this.source.id(), (Throwable)e);
        }
    }

    public void terminate() {
        log.info("removing source " + this.source.id());
        this.unscheduleRefresh();
        this.source.store().delete();
    }

    public void stop() {
        log.info("stopping source " + this.source.id() + " on container shutdown");
        this.unscheduleRefresh();
        this.source.store().stop();
    }

    protected void unscheduleRefresh() {
        if (this.scheduled != null) {
            this.scheduled.cancel(true);
            this.scheduled = null;
        }
    }
}

