/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.speciesplugin;

import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.gcube.data.speciesplugin.SpeciesLifecycle;
import org.gcube.data.speciesplugin.SpeciesReader;
import org.gcube.data.speciesplugin.SpeciesSource;
import org.gcube.data.speciesplugin.requests.RequestBinder;
import org.gcube.data.speciesplugin.requests.SpeciesRequest;
import org.gcube.data.speciesplugin.store.ProductionStoreProvider;
import org.gcube.data.speciesplugin.store.SpeciesStore;
import org.gcube.data.speciesplugin.store.SpeciesStoreProvider;
import org.gcube.data.tmf.api.SourceBinder;
import org.gcube.data.tmf.api.SourceLifecycle;
import org.gcube.data.tmf.api.SourceReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SpeciesBinder
implements SourceBinder {
    private static Logger log = LoggerFactory.getLogger(SpeciesBinder.class);
    private static RequestBinder db = new RequestBinder();
    protected SpeciesStoreProvider provider = new ProductionStoreProvider();

    public List<? extends SpeciesSource> bind(Element request) throws Exception {
        SpeciesRequest speciesRequest = db.bind(request);
        SpeciesStore store = this.provider.newStore(speciesRequest.getId());
        SpeciesSource source = new SpeciesSource(speciesRequest.getId(), store);
        source.setName(speciesRequest.getName());
        source.setDescription(speciesRequest.getDescription());
        SpeciesLifecycle lifecycle = new SpeciesLifecycle(source, speciesRequest.getScientificNames(), speciesRequest.getDatasources());
        source.setLifecycle((SourceLifecycle)lifecycle);
        source.setCreationTime(Calendar.getInstance());
        source.setLastUpdate(Calendar.getInstance());
        SpeciesReader reader = new SpeciesReader(source);
        source.setReader((SourceReader)reader);
        log.info("bound source {}", (Object)source);
        return Collections.singletonList(source);
    }
}

