/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.speciesplugin.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.gbif.dwc.record.Record;
import org.gbif.dwc.terms.ConceptTerm;
import org.gbif.dwc.terms.DcTerm;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.GbifTerm;
import org.gbif.dwc.text.Archive;
import org.gbif.dwc.text.ArchiveFactory;
import org.gbif.dwc.text.StarRecord;
import org.gbif.dwc.text.UnsupportedArchiveException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.client.plugins.AbstractPlugin;
import org.gcube.data.spd.client.proxies.Classification;
import org.gcube.data.spd.client.proxies.DWCACreator;
import org.gcube.data.spd.client.proxies.Manager;
import org.gcube.data.spd.client.proxies.Occurrences;
import org.gcube.data.spd.plugin.fwk.exceptions.IdNotValidException;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.spd.stubs.StatusResponse;
import org.gcube.data.speciesplugin.utils.StorageUtil;
import org.gcube.data.streams.Stream;
import org.gcube.data.tml.exceptions.InvalidTreeException;
import org.gcube.data.tml.exceptions.UnknownTreeException;
import org.gcube.data.tr.Store;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Nodes;
import org.gcube.data.trees.data.Tree;

public class OldSpeciesService {
    private static GCUBELog logger = new GCUBELog(OldSpeciesService.class);
    protected File storeLocation;
    protected Manager call;
    protected Occurrences occurrencesCall;
    protected Classification classificationCall;
    protected DWCACreator dwcaCall;
    protected Store store;

    public OldSpeciesService(Store store) throws Exception {
        this.store = store;
        logger.trace((Object)"CALLING MANAGER ");
        this.call = (Manager)AbstractPlugin.manager().at(new URI("http://node24.d.d4science.research-infrastructures.eu:8080/")).withTimeout(3, TimeUnit.MINUTES).build();
        this.dwcaCall = (DWCACreator)AbstractPlugin.dwcaCreator().at(new URI("http://node24.d.d4science.research-infrastructures.eu:8080/")).withTimeout(3, TimeUnit.MINUTES).build();
        this.occurrencesCall = (Occurrences)AbstractPlugin.occurrences().at(new URI("http://node24.d.d4science.research-infrastructures.eu:8080/")).withTimeout(3, TimeUnit.MINUTES).build();
        this.classificationCall = (Classification)AbstractPlugin.classification().at(new URI("http://node24.d.d4science.research-infrastructures.eu:8080/")).withTimeout(3, TimeUnit.MINUTES).build();
    }

    public void createCollection(List<String> scientificNames, List<String> dataSource) throws Exception {
        String query = this.createQuery(scientificNames, dataSource);
        logger.trace((Object)query);
        ArrayList<File> listDwCAFiles = new ArrayList<File>();
        Stream stream = this.call.search(query.toString());
        while (stream.hasNext()) {
            TaxonomyItem taxon = (TaxonomyItem)stream.next();
            if (!this.checkEquals(scientificNames, taxon.getScientificName())) continue;
            logger.trace((Object)(" --- " + taxon.getId()));
            try {
                File DwcFile = this.createSpeciesJob(taxon.getId());
                listDwCAFiles.add(DwcFile);
                logger.trace((Object)(" --- " + DwcFile));
            }
            catch (Exception e) {
                logger.error((Object)"Exception", (Throwable)e);
            }
        }
        List<Tree> TreeList = this.createTrees(listDwCAFiles);
        this.saveInStore(TreeList);
        for (File f : listDwCAFiles) {
            logger.trace((Object)("delete " + f.toString()));
            f.delete();
        }
    }

    private List<Tree> createTrees(List<File> listDwCAFiles) throws Exception {
        List<Tree> treeList = new ArrayList<Tree>();
        HashSet<String> ids = new HashSet<String>();
        for (File f : listDwCAFiles) {
            treeList = this.createTreeByDwCA(f, treeList, ids);
        }
        return treeList;
    }

    protected List<Tree> createTreeByDwCA(File f, List<Tree> treeList, HashSet<String> insertedIds) throws Exception {
        try {
            logger.trace((Object)f);
            File tmp = File.createTempFile("species", "Dir");
            tmp.delete();
            tmp.mkdir();
            Archive arch = ArchiveFactory.openArchive((File)f, (File)tmp);
            if (!arch.getCore().hasTerm((ConceptTerm)DwcTerm.scientificName)) {
                throw new Exception("This application requires dwc-a with scientific names");
            }
            for (StarRecord dwc : arch) {
                if (insertedIds.contains(String.valueOf(dwc.core().id()) + "-" + dwc.core().value((ConceptTerm)DwcTerm.scientificName))) continue;
                try {
                    treeList.add(this.createTree(dwc));
                    String id = String.valueOf(dwc.core().id()) + "-" + dwc.core().value((ConceptTerm)DwcTerm.scientificName);
                    insertedIds.add(id);
                    logger.trace((Object)id);
                }
                catch (Exception e) {
                    logger.error((Object)"Error creating tree from DwC-A", (Throwable)e);
                }
            }
            this.deleteTmpDir(tmp);
            logger.trace((Object)"completed!");
            return treeList;
        }
        catch (UnsupportedArchiveException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return treeList;
    }

    private void saveInStore(List<Tree> TreeList) throws UnknownTreeException, Exception {
        for (Tree tree : TreeList) {
            Tree tree2 = this.store.add(tree);
        }
    }

    private String createQuery(List<String> scientificNames, List<String> dataSource) {
        StringBuilder query = new StringBuilder();
        Iterator<String> itScNames = scientificNames.iterator();
        while (itScNames.hasNext()) {
            query.append(" '");
            query.append(itScNames.next());
            query.append("' ");
            if (!itScNames.hasNext()) continue;
            query.append(", ");
        }
        query.append(" as ScientificName ");
        if (dataSource.size() > 0) {
            query.append(" in ");
            Iterator<String> itDataSource = dataSource.iterator();
            while (itDataSource.hasNext()) {
                query.append(itDataSource.next());
                if (!itDataSource.hasNext()) continue;
                query.append(", ");
            }
        }
        query.append(" return Taxon");
        return query.toString();
    }

    private boolean checkEquals(List<String> scientificNames, String scientificName) {
        for (String name : scientificNames) {
            if (!name.equalsIgnoreCase(scientificName)) continue;
            return true;
        }
        return false;
    }

    public File createSpeciesJob(String taxonomyId) throws Exception {
        try {
            File dwcFile = null;
            String jobId = this.dwcaCall.getByChilds(taxonomyId);
            StatusResponse status = this.getStatusById(jobId);
            while (!status.getStatus().equals("FAILED") & !status.getStatus().equals("COMPLETED")) {
                Thread.sleep(4000L);
                status = this.getStatusById(jobId);
            }
            if (!status.getStatus().equals("COMPLETED")) {
                throw new Exception("job uncompleted");
            }
            dwcFile = this.saveDwCA(jobId);
            return dwcFile;
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            throw new Exception("Error creating SpeciesJob ", e);
        }
    }

    public File saveDwCA(String jobId) throws Exception {
        try {
            InputStream inputStream = this.getJobFileById(jobId);
            File tmp = File.createTempFile("species", ".tmp");
            FileOutputStream os = new FileOutputStream(tmp);
            IOUtils.copy((InputStream)inputStream, (OutputStream)os);
            ((OutputStream)os).close();
            logger.trace((Object)"Save completed");
            return tmp;
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            throw new Exception("Error saving InputStream ", e);
        }
    }

    public InputStream getJobFileById(String jobIdentifier) throws Exception {
        try {
            String url = this.dwcaCall.getResultLink(jobIdentifier);
            logger.trace((Object)("URL returned by species service is: " + url));
            InputStream is = StorageUtil.storageClient(url);
            return is;
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            throw new Exception("Error retrieving InputStream ", e);
        }
    }

    public StatusResponse getStatusById(String jobId) {
        try {
            return this.dwcaCall.getStatus(jobId);
        }
        catch (IdNotValidException e) {
            logger.error((Object)"Error on service for get job by Id - IDNotValidException");
            return null;
        }
        catch (Exception e) {
            logger.error((Object)("Error on service for get job by Id: " + e.getMessage()), (Throwable)e);
            return new StatusResponse();
        }
    }

    private void deleteTmpDir(File f) {
        if (f.exists()) {
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File c = fileArray[n2];
                if (c.isDirectory()) {
                    this.deleteTmpDir(c);
                }
                c.delete();
                ++n2;
            }
            f.delete();
        }
        logger.trace((Object)"Files deleted");
    }

    private Tree createTree(StarRecord dwc) throws UnknownTreeException, InvalidTreeException, Exception {
        Record dwcRecord = dwc.core();
        Tree tree = new Tree(new Edge[]{Nodes.e((String)DwcTerm.acceptedNameUsageID.name(), (Object)dwcRecord.value((ConceptTerm)DwcTerm.acceptedNameUsageID)), Nodes.e((String)DwcTerm.parentNameUsageID.name(), (Object)dwcRecord.value((ConceptTerm)DwcTerm.parentNameUsageID)), Nodes.e((String)DwcTerm.scientificName.name(), (Object)dwcRecord.value((ConceptTerm)DwcTerm.scientificName)), Nodes.e((String)DwcTerm.scientificNameAuthorship.name(), (Object)dwcRecord.value((ConceptTerm)DwcTerm.scientificNameAuthorship)), Nodes.e((String)DwcTerm.kingdom.name(), (Object)dwcRecord.value((ConceptTerm)DwcTerm.kingdom)), Nodes.e((String)DwcTerm.phylum.name(), (Object)dwcRecord.value((ConceptTerm)DwcTerm.phylum)), Nodes.e((String)DwcTerm.classs.name(), (Object)dwcRecord.value((ConceptTerm)DwcTerm.classs)), Nodes.e((String)DwcTerm.order.name(), (Object)dwcRecord.value((ConceptTerm)DwcTerm.order)), Nodes.e((String)DwcTerm.family.name(), (Object)dwcRecord.value((ConceptTerm)DwcTerm.family)), Nodes.e((String)DwcTerm.genus.name(), (Object)dwcRecord.value((ConceptTerm)DwcTerm.genus)), Nodes.e((String)DwcTerm.subgenus.name(), (Object)dwcRecord.value((ConceptTerm)DwcTerm.subgenus)), Nodes.e((String)DwcTerm.specificEpithet.name(), (Object)dwcRecord.value((ConceptTerm)DwcTerm.specificEpithet)), Nodes.e((String)DwcTerm.infraspecificEpithet.name(), (Object)dwcRecord.value((ConceptTerm)DwcTerm.infraspecificEpithet)), Nodes.e((String)DwcTerm.verbatimTaxonRank.name(), (Object)dwcRecord.value((ConceptTerm)DwcTerm.verbatimTaxonRank)), Nodes.e((String)DwcTerm.taxonRank.name(), (Object)dwcRecord.value((ConceptTerm)DwcTerm.taxonRank)), Nodes.e((String)DwcTerm.taxonomicStatus.name(), (Object)dwcRecord.value((ConceptTerm)DwcTerm.taxonomicStatus)), Nodes.e((String)DcTerm.modified.name(), (Object)dwcRecord.value((ConceptTerm)DcTerm.modified)), Nodes.e((String)DwcTerm.taxonRemarks.name(), (Object)dwcRecord.value((ConceptTerm)DwcTerm.taxonRemarks)), Nodes.e((String)DcTerm.bibliographicCitation.name(), (Object)dwcRecord.value((ConceptTerm)DcTerm.bibliographicCitation))});
        tree.setAttribute("DataSourceId", dwcRecord.id());
        for (Record extRecord : dwc.extension(GbifTerm.VernacularName.qualifiedName())) {
            tree.add(Nodes.e((String)"vernacularName", (Node)Nodes.n((Edge[])new Edge[]{Nodes.e((String)DwcTerm.vernacularName.name(), (Object)extRecord.value((ConceptTerm)DwcTerm.vernacularName)), Nodes.e((String)DcTerm.language.name(), (Object)extRecord.value((ConceptTerm)DcTerm.language)), Nodes.e((String)DwcTerm.locality.name(), (Object)extRecord.value((ConceptTerm)DwcTerm.locality))})));
        }
        return tree;
    }
}

