/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.speciesplugin.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.client.plugins.AbstractPlugin;
import org.gcube.data.spd.client.proxies.Classification;
import org.gcube.data.spd.client.proxies.DWCACreator;
import org.gcube.data.spd.client.proxies.Manager;
import org.gcube.data.spd.client.proxies.Occurrences;
import org.gcube.data.spd.plugin.fwk.model.CommonName;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.speciesplugin.store.SpeciesStore;
import org.gcube.data.streams.Stream;
import org.gcube.data.tml.exceptions.InvalidTreeException;
import org.gcube.data.tml.exceptions.UnknownTreeException;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.InnerNode;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Nodes;
import org.gcube.data.trees.data.Tree;

public class SpeciesService {
    public static final String SPECIES_SERVICE_ID = "SpeciesServiceId";
    private static GCUBELog logger = new GCUBELog(SpeciesService.class);
    protected File storeLocation;
    protected Manager call;
    protected Occurrences occurrencesCall;
    protected Classification classificationCall;
    protected DWCACreator dwcaCall;
    protected SpeciesStore store;

    public SpeciesService(SpeciesStore store) throws Exception {
        this.store = store;
        logger.trace((Object)"CALLING MANAGER ");
        this.call = (Manager)AbstractPlugin.manager().withTimeout(3, TimeUnit.MINUTES).build();
        this.classificationCall = (Classification)AbstractPlugin.classification().withTimeout(3, TimeUnit.MINUTES).build();
    }

    public void createCollection(List<String> scientificNames, List<String> dataSource) throws Exception {
        String query = this.createQuery(scientificNames, dataSource);
        logger.trace((Object)query);
        Stream stream = this.call.search(query.toString());
        while (stream.hasNext()) {
            TaxonomyItem taxon = (TaxonomyItem)stream.next();
            if (!this.checkEquals(scientificNames, taxon.getScientificName())) continue;
            logger.trace((Object)(" --- " + taxon.getId()));
            try {
                Stream TaxItems = this.classificationCall.getTaxonTreeById(taxon.getId());
                List<Tree> TreeList = this.createTrees((Stream<TaxonomyItem>)TaxItems);
                this.saveInStore(TreeList);
            }
            catch (Exception e) {
                logger.error((Object)"Exception", (Throwable)e);
            }
        }
    }

    private String createQuery(List<String> scientificNames, List<String> dataSource) {
        StringBuilder query = new StringBuilder();
        Iterator<String> itScNames = scientificNames.iterator();
        while (itScNames.hasNext()) {
            query.append(" '");
            query.append(itScNames.next());
            query.append("' ");
            if (!itScNames.hasNext()) continue;
            query.append(", ");
        }
        query.append(" as ScientificName ");
        if (dataSource.size() > 0) {
            query.append(" in ");
            Iterator<String> itDataSource = dataSource.iterator();
            while (itDataSource.hasNext()) {
                query.append(itDataSource.next());
                if (!itDataSource.hasNext()) continue;
                query.append(", ");
            }
        }
        query.append(" return Taxon");
        return query.toString();
    }

    private boolean checkEquals(List<String> scientificNames, String scientificName) {
        for (String name : scientificNames) {
            if (!name.equalsIgnoreCase(scientificName)) continue;
            return true;
        }
        return false;
    }

    private void saveInStore(List<Tree> TreeList) throws UnknownTreeException, Exception {
        for (Tree tree : TreeList) {
            Tree tree2 = this.store.add(tree);
        }
    }

    private List<Tree> createTrees(Stream<TaxonomyItem> TaxItems) throws Exception {
        ArrayList<Tree> treeList = new ArrayList<Tree>();
        while (TaxItems.hasNext()) {
            TaxonomyItem item = (TaxonomyItem)TaxItems.next();
            logger.trace((Object)item.getScientificName());
            logger.trace((Object)item.getRank());
            logger.trace((Object)item.getProvider());
            treeList.add(this.createTree(item));
        }
        return treeList;
    }

    private Tree createTree(TaxonomyItem item) throws UnknownTreeException, InvalidTreeException, Exception {
        Tree tree = new Tree(new Edge[]{Nodes.e((String)"author", (Object)item.getAuthor()), Nodes.e((String)"citation", (Object)item.getCitation()), Nodes.e((String)"credits", (Object)item.getCredits()), Nodes.e((String)"LSID", (Object)item.getLsid()), Nodes.e((String)"modified", (Object)item.getModified()), Nodes.e((String)"provider", (Object)item.getProvider()), Nodes.e((String)"rank", (Object)item.getRank()), Nodes.e((String)"scientificName", (Object)item.getScientificName()), Nodes.e((String)"status", (Node)Nodes.n((Edge[])new Edge[]{Nodes.e((String)"language", (Object)item.getStatus().getRefId()), Nodes.e((String)"locality", (Object)item.getStatus().getStatus()), Nodes.e((String)"name", (Object)item.getStatus().getStatusAsString())}))});
        InnerNode commonNames = new InnerNode(new Edge[0]);
        Edge commonNamesEdge = new Edge(new QName("commonNames"), (Node)commonNames);
        tree.add(commonNamesEdge);
        if (item.getCommonNames() != null) {
            for (CommonName c : item.getCommonNames()) {
                commonNames.add(Nodes.e((String)"commonName", (Node)Nodes.n((Edge[])new Edge[]{Nodes.e((String)"language", (Object)c.getLanguage()), Nodes.e((String)"locality", (Object)c.getLocality()), Nodes.e((String)"name", (Object)c.getName())})));
            }
        }
        tree.setAttribute(SPECIES_SERVICE_ID, item.getId());
        return tree;
    }
}

