package org.gcube.data.streams.exceptions;

import org.gcube.data.streams.Stream;


/**
 * A failure that models a recoverable contingency in a {@link Stream} iteration.
 *  
 * @author Fabio Simeoni
 *
 */
public class StreamContingencyException extends StreamException {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * Creates an instance with a given cause.
	 * @param cause the cause
	 */
	public StreamContingencyException(Throwable cause) {
		super(cause);
	}
	
	/**
	 * Creates an instance with a given message and a given cause.
	 * @param msg the message
	 * @param cause the cause
	 */
	public StreamContingencyException(String msg, Throwable cause) {
		super(msg,cause);
	}

	
}
