/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.streams.delegates;

import java.net.URI;
import org.gcube.data.streams.LookAheadStream;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.delegates.StreamListener;

public class MonitoredStream<E>
extends LookAheadStream<E> {
    private final Stream<E> stream;
    private final StreamListener listener;
    private boolean started = false;

    public MonitoredStream(Stream<E> stream, StreamListener listener) throws IllegalArgumentException {
        if (stream == null) {
            throw new IllegalArgumentException("invalid null stream");
        }
        if (listener == null) {
            throw new IllegalArgumentException("invalid null listener");
        }
        this.stream = stream;
        this.listener = listener;
    }

    @Override
    protected E delegateNext() {
        E element = this.stream.next();
        if (!this.started) {
            this.listener.onStart();
            this.started = true;
        }
        if (!this.delegateHasNext()) {
            this.listener.onEnd();
        }
        return element;
    }

    @Override
    protected boolean delegateHasNext() {
        return this.stream.hasNext();
    }

    @Override
    public void close() {
        this.stream.close();
        this.listener.onClose();
    }

    @Override
    public URI locator() throws IllegalStateException {
        return this.stream.locator();
    }

    @Override
    public void remove() {
        this.stream.remove();
    }
}

