package org.gcube.data.streams.generators;

import org.gcube.data.streams.Stream;
import org.gcube.data.streams.exceptions.StreamSkipException;
import org.gcube.data.streams.exceptions.StreamContingencyException;

/**
 * Yields elements of a {@link Stream} from elements of another {@link Stream}.
 * 
 * @author Fabio Simeoni
 *
 * @param <E1> the type of elements in the input stream
 * @param <E2> the type of elements in the output stream
 * 
 * @see Stream
 */
public interface Generator<E1,E2> {

	/**
	 * Yields an element of a {@link Stream} from an element of another {@link Stream}.
	 * 
	 * @param element the input element
	 * @return the output element 
	 * @throws StreamSkipException if no element should be yielded from the input element
	 * @throws StreamContingencyException if no element can be yielded, because the input element violates pre-conditions
	 * @throws RuntimeException if no element can be yielded from the input element, becuase of an unrecoverable condition
	 */
	E2 yield(E1 element) throws StreamSkipException,StreamContingencyException;
}
