/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.streams.dsl.from;

import gr.uoa.di.madgik.grs.record.Record;
import java.util.concurrent.TimeUnit;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.adapters.ResultsetStream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.dsl.from.RsClause;
import org.gcube.data.streams.dsl.from.RsEnv;
import org.gcube.data.streams.generators.Generator;

public class RsWithClause<R extends Record>
extends RsClause<R> {
    public RsWithClause(RsEnv<R> env) {
        super(env);
    }

    public Stream<R> withTimeout(int timeout, TimeUnit unit) {
        ResultsetStream stream = new ResultsetStream(this.env.locator);
        stream.setTimeout(timeout, unit);
        return Streams.pipe(stream).through(new RecordDeserialiser(this.env.recordClass));
    }

    public Stream<R> withDefaults() {
        return new ResultsetStream(this.env.locator);
    }

    private static class RecordDeserialiser<R extends Record>
    implements Generator<Record, R> {
        private final Class<R> recordClass;

        public RecordDeserialiser(Class<R> recordClass) {
            this.recordClass = recordClass;
        }

        @Override
        public R yield(Record element) {
            return (R)((Record)this.recordClass.cast(element));
        }
    }
}

