package org.gcube.data.tml.clients;

import java.net.URL;

import javax.xml.namespace.QName;

import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.gcube.common.clients.Call;
import org.gcube.data.tm.stubs.TBinderPortType;
import org.gcube.data.tm.stubs.TReaderPortType;
import org.gcube.data.tm.stubs.TWriterPortType;
import org.gcube.data.tml.Constants;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.utils.AnyHelper;

class APIUtils {

	static EndpointReferenceType endpoint(URL address, String service,
			String key) {

		EndpointReferenceType epr = endpoint(address, service);
		try {
			SimpleResourceKey resourceKey = new SimpleResourceKey(new QName(
					Constants.NS, "ResourceKey"), key);
			ReferencePropertiesType props = new ReferencePropertiesType();
			AnyHelper.setAny(props, resourceKey.toSOAPElement());
			epr.setProperties(props);
			return epr;
		} 
		catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	static EndpointReferenceType endpoint(URL address, String service) {

		try {
			EndpointReferenceType epr = new EndpointReferenceType();
			epr.setAddress(new AttributedURI("http://" + address.getHost()
					+ ":" + address.getPort() + "/wsrf/services/" + service));
			return epr;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	// AUXILIARY STRUCTURES FOR THE CALL FRAMEWORK

	// a simplifying interface
	static interface TReaderCall<R> extends Call<TReaderPortType, R> {
	};

	// a simplifying interface
	static interface TWriterCall<R> extends Call<TWriterPortType, R> {
	};

	// a simplifying interface
	static interface TBinderCall<R> extends Call<TBinderPortType, R> {
	};

}
