package org.gcube.data.tml.outcomes;

import org.gcube.data.trees.data.Tree;

/**
 * The outcome of adding a {@link Tree} to a data source.
 * 
 * @author Fabio Simeoni
 *
 */
public class AddTreeOutcome {

	private Tree tree;
	private Exception failure;
	
	/**
	 * Creates an instance with successfully added tree.
	 * @param tree the tree
	 */
	public AddTreeOutcome(Tree tree) {
		this.tree=tree;
	}
	
	/**
	 * Creates an instance with the exception raised when attempting to add a tree.
	 * @param failure the exception
	 */
	public AddTreeOutcome(Exception failure) {
		this.failure=failure;
	}
	
	/**
	 * Returns <code>true</code> if the outcome indicates success.
	 * <p>
	 * In this case, {@link #tree()} is guaranteed not to be <code>null</code>, while
	 * {@link #failure()} is guaranteed to be <code>null</code>
	 * 
	 * @return <code>true</code> if the outcome indicates success, <code>false</code> otherwise
	 */
	public boolean isSuccess() {
		return tree!=null;
	}

	/**
	 * Returns <code>true</code> if the outcome indicates a failure.
	 * 
	 * In this case, {@link #failure()} is guaranteed not to be <code>null</code>, while
	 * {@link #tree()} is guaranteed to be <code>null</code>
	 * 
	 * @return <code>true</code> if the outcome indicates a failure, <code>false</code> otherwise
	 */
	public boolean isFailure() {
		return failure!=null;
	}
	
	/**
	 * Returns the successfully added tree.
	 * @return the tree, or <code>null</code> if the outcome indicates a failure
	 */
	public Tree tree() {
		return tree;
	}
	
	/**
	 * Returns the exception raised when unsuccessfully adding a tree.
	 * @return the exception, or <code>null</code> if the outcome indicates a success
	 */
	public Exception failure() {
		return failure;
	}
	
	@Override
	public String toString() {
		return isSuccess() ? tree().toString() : failure().toString();
	}
}
