/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tml.plugins;

import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.exceptions.InvalidRequestException;
import org.gcube.common.clients.exceptions.ServiceException;
import org.gcube.common.clients.exceptions.UnsupportedOperationException;
import org.gcube.common.clients.exceptions.UnsupportedRequestException;
import org.gcube.common.clients.gcore.plugins.Plugin;
import org.gcube.common.core.faults.FaultUtils;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.data.tm.stubs.InvalidRequestFault;
import org.gcube.data.tm.stubs.InvalidTreeFault;
import org.gcube.data.tm.stubs.UnknownPathFault;
import org.gcube.data.tm.stubs.UnknownTreeFault;
import org.gcube.data.tm.stubs.UnsupportedOperationFault;
import org.gcube.data.tm.stubs.UnsupportedRequestFault;
import org.gcube.data.tml.exceptions.InvalidTreeException;
import org.gcube.data.tml.exceptions.UnknownPathException;
import org.gcube.data.tml.exceptions.UnknownTreeException;

public abstract class AbstractPlugin<S, P>
implements Plugin<S, P> {
    public final String name;

    public AbstractPlugin(String name) {
        this.name = name;
    }

    public String serviceClass() {
        return "DataAccess";
    }

    public String serviceName() {
        return "tree-manager-service";
    }

    public String namespace() {
        return "http://gcube-system.org/namespaces/data/tm";
    }

    public String name() {
        return this.name;
    }

    public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
        if (fault instanceof GCUBEFault) {
            Throwable cause = FaultUtils.remoteCause((GCUBEFault)((GCUBEFault)fault));
            if (fault instanceof InvalidRequestFault) {
                return new InvalidRequestException(cause);
            }
            if (fault instanceof UnsupportedOperationFault) {
                return new UnsupportedOperationException("operation is not supported by target plugin");
            }
            if (fault instanceof UnsupportedRequestFault) {
                return new UnsupportedRequestException("request is not supported by target plugin");
            }
            if (fault instanceof UnknownTreeFault) {
                return new UnknownTreeException(cause);
            }
            if (fault instanceof InvalidTreeFault) {
                return new InvalidTreeException(cause);
            }
            if (fault instanceof UnknownPathFault) {
                return new UnknownPathException(cause);
            }
            if (fault instanceof GCUBEFault) {
                return new ServiceException(cause);
            }
        }
        return fault;
    }
}

