package org.gcube.data.tml.proxies;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.clients.gcore.Utils;
import org.gcube.data.tm.stubs.SourceBinding;

public class Binding {

	private final SourceBinding stub;
	
	public Binding(SourceBinding stub) {
		this.stub=stub;
	}
	
	public String source() {
		return stub.getSourceID();
	}
	
	public W3CEndpointReference readerRef() {
		EndpointReferenceType address = stub.getReaderEndpoint();
		return address == null?null:Utils.convert(address);
	}
	
	public W3CEndpointReference writerRef() {
		EndpointReferenceType address = stub.getWriterEndpoint();
		return address == null?null:Utils.convert(address);
	}
	
	@Override
	public String toString() {
		return "source:"+source()+
				(readerRef()==null?"":"\nreader:"+readerRef())+
				(writerRef()==null?"":"\nwriter:"+writerRef());
	}
	
}
