/**
 * 
 */
package org.acme.sample.tmplugin.requests;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.acme.sample.tmplugin.data.DataBinder;
import org.w3c.dom.Element;


/**
 * @author Fabio Simeoni
 *
 */
@XmlRootElement
public class SampleRequest {

	@XmlElement
	private String id;
	
	@XmlElement
	private String description;
	
	@XmlElement
	private BindMode mode;
	
	SampleRequest() {} //required for deserialization
	
	public SampleRequest(String id) {
		this(id,BindMode.READ_ONLY);
	}
	
	public SampleRequest(String id,BindMode mode) {
		this.id=id;
		this.mode=mode;
	}
	
	public String id() {
		return id;
	}
	
	public BindMode mode() {
		return mode;
	}
	
	
	public String description() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}
	
	public Element toElement() {
		try {
			return new DataBinder().bind(this);
		}
		catch(Exception e) {
			throw new RuntimeException(e);
		}
 	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		SampleRequest other = (SampleRequest) obj;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		return true;
	}
}
