package org.acme.sample.tmplugin.data;

import static org.gcube.data.trees.data.Nodes.*;

import java.io.Serializable;

import javax.xml.bind.JAXBContext;
import javax.xml.parsers.DocumentBuilderFactory;

import org.acme.sample.tmplugin.requests.SampleRequest;
import org.gcube.common.clients.exceptions.InvalidRequestException;
import org.gcube.data.tml.exceptions.InvalidTreeException;
import org.gcube.data.trees.data.Tree;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DataBinder implements Serializable {

	private static final long serialVersionUID = 1L;
	
	private static JAXBContext jaxb;
	private static Class<?>[] paramTypes = new Class<?>[]{SampleRequest.class,SampleData.class};
	
	private synchronized JAXBContext jaxb() throws Exception {
		
		if (jaxb==null) 
			jaxb = JAXBContext.newInstance(paramTypes);
		return jaxb;
	}
	
	public SampleRequest bind(Element e) throws InvalidRequestException {
		try {
			return (SampleRequest) jaxb().createUnmarshaller().unmarshal(e);	
		}
		catch(Exception ex) {
			throw new InvalidRequestException("unknown request "+e.getNodeName(),ex);
		}
	}
	
	public Tree bind(SampleData data) throws Exception {
		//distinguish new from stored trees
		if (data.id()==null)
			return t(e("val",data.val()));
		else
			return t(data.id(),e("val",l("val",data.val()))); //note: we use name of edge as leaf identifier
	}
	
	public SampleData bind(Tree tree) throws Exception {
		if (tree.hasEdge("val"))
			return new SampleData(tree.id(),Integer.valueOf(tree.child(L,"val").value()));
		else
			if (tree.edges().size()>0)
				throw new InvalidTreeException();
		else
			return new SampleData(tree.id());
	}
	
	//useful for testing
	public Element bind(Object o) throws Exception {
		Document d = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
		jaxb().createMarshaller().marshal(o,d);
		return d.getDocumentElement();
	}
}
