/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tm.plugin;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.tm.plugin.PluginEnvironment;
import org.gcube.data.tmf.api.Environment;
import org.gcube.data.tmf.api.Plugin;
import org.gcube.data.tmf.api.PluginLifecycle;

public class PluginManager {
    private static GCUBELog log = new GCUBELog(PluginManager.class);
    private static ServiceLoader<Plugin> loader;
    private static Map<String, Plugin> plugins;

    public PluginManager() {
        if (loader == null) {
            loader = ServiceLoader.load(Plugin.class);
            for (Plugin plugin : loader) {
                if (plugin.name() == null) {
                    log.error((Object)("plugin " + plugin.getClass().getSimpleName() + " has a null name"));
                    continue;
                }
                if (plugin.name() == null) {
                    log.warn((Object)("plugin " + plugin.getClass().getSimpleName() + " has a null description"));
                    continue;
                }
                if (plugin.binder() == null) {
                    log.error((Object)("plugin " + plugin.name() + " binder is null"));
                    continue;
                }
                log.info((Object)("registering plugin " + plugin.name()));
                if (plugin instanceof PluginLifecycle) {
                    try {
                        ((PluginLifecycle)plugin).start((Environment)new PluginEnvironment());
                    }
                    catch (Throwable e) {
                        log.error((Object)"cannot initialise plugin", e);
                    }
                }
                plugins.put(plugin.name(), plugin);
            }
        }
    }

    public Map<String, Plugin> plugins() {
        return new HashMap<String, Plugin>(plugins);
    }

    public void stop() {
        PluginManager manager = new PluginManager();
        for (Plugin plugin : manager.plugins().values()) {
            this.stop(plugin);
        }
    }

    public void stop(Plugin plugin) {
        if (plugin instanceof PluginLifecycle) {
            ((PluginLifecycle)plugin).stop((Environment)new PluginEnvironment());
        }
    }

    static {
        plugins = new HashMap<String, Plugin>();
    }
}

