/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tm.services;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBERetryEquivalentFault;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.handlers.GCUBEScheduledHandler;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.tm.activationrecord.ActivationRecord;
import org.gcube.data.tm.activationrecord.ActivationRecordBody;
import org.gcube.data.tm.context.ServiceContext;
import org.gcube.data.tm.context.TBinderContext;
import org.gcube.data.tm.publishers.ResilientScheduler;
import org.gcube.data.tm.state.TBinderResource;
import org.gcube.data.tm.stubs.BindOutcome;
import org.gcube.data.tm.stubs.BindOutcomeFailure;
import org.gcube.data.tm.stubs.BindParameters;
import org.gcube.data.tm.stubs.InvalidRequestFault;
import org.gcube.data.tm.stubs.SourceBinding;
import org.gcube.data.tm.stubs.SourceBindings;
import org.gcube.data.tml.Constants;
import org.gcube.data.tml.clients.BindingParameters;
import org.gcube.data.tml.exceptions.InvalidRequestException;
import org.gcube.data.tml.utils.Utils;
import org.globus.wsrf.encoding.ObjectSerializer;

public class TBinderService {
    private static GCUBELog logger = new GCUBELog(TBinderService.class);

    public SourceBindings bind(BindParameters parameters) throws InvalidRequestFault, GCUBEFault {
        return this.bind(new BindingParameters(parameters));
    }

    SourceBindings bind(BindingParameters parameters) throws InvalidRequestFault, GCUBEFault {
        try {
            if (parameters == null) {
                throw new InvalidRequestException("request carries null parameters");
            }
            String pluginName = parameters.getPlugin();
            TBinderResource binder = TBinderContext.getContext().binder();
            if (parameters.isBroadcast() && binder.getPlugin(pluginName).isAnchored()) {
                throw new InvalidRequestException("cannot broadcast: plugin is anchored, its state cannot be replicated");
            }
            List<SourceBinding> bindings = binder.bind(pluginName, parameters.getPayload());
            if (bindings.size() > 0 && parameters.isBroadcast()) {
                this.buildAndPublishActivationRecord(binder, parameters);
            }
            return new SourceBindings(bindings.toArray(new SourceBinding[0]));
        }
        catch (InvalidRequestException e) {
            throw (InvalidRequestFault)Utils.newFault((GCUBEFault)new InvalidRequestFault(), (Throwable)e);
        }
        catch (Exception e) {
            throw (GCUBERetryEquivalentFault)Utils.newFault((GCUBEFault)new GCUBERetryEquivalentFault(), (Throwable)e);
        }
    }

    private void buildAndPublishActivationRecord(TBinderResource binder, BindingParameters parameters) {
        try {
            String id = ServiceContext.getContext().getInstance().getID();
            ActivationRecordBody body = new ActivationRecordBody(id, parameters);
            String description = "An activation of the T-Binder Service";
            ActivationRecord record = ActivationRecord.newInstance(description, body);
            ResilientScheduler scheduler = new ResilientScheduler(1L, GCUBEScheduledHandler.Mode.LAZY);
            scheduler.setAttempts(10);
            scheduler.setDelay(10L);
            scheduler.setScopeManager((GCUBEScopeManager)ServiceContext.getContext());
            scheduler.setSecurityManager((GCUBESecurityManager)ServiceContext.getContext());
            record.publish(scheduler);
            binder.addActivation(record);
        }
        catch (Throwable t) {
            logger.error((Object)("could not publish activation record " + parameters), t);
        }
    }

    public String bindAsync(BindParameters parameters) throws GCUBEFault {
        try {
            RecordWriter writer = new RecordWriter((IWriterProxy)new TCPWriterProxy(), Constants.UNTYPED_RECORD);
            AsynchronousBinder binder = new AsynchronousBinder((RecordWriter<GenericRecord>)writer, parameters);
            ServiceContext.getContext().newServiceThread(binder).start();
            return writer.getLocator().toString();
        }
        catch (GRS2WriterException e) {
            throw (GCUBERetryEquivalentFault)Utils.newFault((GCUBEFault)new GCUBERetryEquivalentFault(), (Throwable)e);
        }
    }

    private class AsynchronousBinder
    implements Runnable {
        private final RecordWriter<GenericRecord> writer;
        private final BindParameters parameters;

        AsynchronousBinder(RecordWriter<GenericRecord> writer, BindParameters parameters) {
            this.writer = writer;
            this.parameters = parameters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block30: {
                BindOutcome response = new BindOutcome();
                response.setSuccess(TBinderService.this.bind(this.parameters));
                try {
                    if (this.writer.getStatus() == IBuffer.Status.Open) {
                        StringWriter w = new StringWriter();
                        ObjectSerializer.serialize((Writer)w, (Object)response, (QName)BindOutcome.getTypeDesc().getXmlType());
                        GenericRecord record = new GenericRecord();
                        record.setFields(new Field[]{new StringField(w.toString())});
                        this.writer.put((Record)record, 5L, TimeUnit.SECONDS);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"could not write out asynchronous response ", (Throwable)e);
                }
                if (this.writer.getStatus() != IBuffer.Status.Dispose) {
                    try {
                        this.writer.close();
                    }
                    catch (GRS2WriterException e) {
                        logger.warn((Object)"error closing the resultset", (Throwable)e);
                    }
                }
                break block30;
                catch (InvalidRequestFault f) {
                    response.setFailure(new BindOutcomeFailure((GCUBEFault)f));
                    try {
                        if (this.writer.getStatus() == IBuffer.Status.Open) {
                            StringWriter w = new StringWriter();
                            ObjectSerializer.serialize((Writer)w, (Object)response, (QName)BindOutcome.getTypeDesc().getXmlType());
                            GenericRecord record = new GenericRecord();
                            record.setFields(new Field[]{new StringField(w.toString())});
                            this.writer.put((Record)record, 5L, TimeUnit.SECONDS);
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"could not write out asynchronous response ", (Throwable)e);
                    }
                    if (this.writer.getStatus() != IBuffer.Status.Dispose) {
                        try {
                            this.writer.close();
                        }
                        catch (GRS2WriterException e) {
                            logger.warn((Object)"error closing the resultset", (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    response.setFailure(new BindOutcomeFailure(ServiceContext.getContext().getDefaultException(e).toFault(new String[0])));
                    {
                        catch (Throwable throwable) {
                            try {
                                if (this.writer.getStatus() == IBuffer.Status.Open) {
                                    StringWriter w = new StringWriter();
                                    ObjectSerializer.serialize((Writer)w, (Object)response, (QName)BindOutcome.getTypeDesc().getXmlType());
                                    GenericRecord record = new GenericRecord();
                                    record.setFields(new Field[]{new StringField(w.toString())});
                                    this.writer.put((Record)record, 5L, TimeUnit.SECONDS);
                                }
                            }
                            catch (Exception e2) {
                                logger.error((Object)"could not write out asynchronous response ", (Throwable)e2);
                            }
                            if (this.writer.getStatus() != IBuffer.Status.Dispose) {
                                try {
                                    this.writer.close();
                                }
                                catch (GRS2WriterException e3) {
                                    logger.warn((Object)"error closing the resultset", (Throwable)e3);
                                }
                            }
                            throw throwable;
                        }
                    }
                    try {
                        if (this.writer.getStatus() == IBuffer.Status.Open) {
                            StringWriter w = new StringWriter();
                            ObjectSerializer.serialize((Writer)w, (Object)response, (QName)BindOutcome.getTypeDesc().getXmlType());
                            GenericRecord record = new GenericRecord();
                            record.setFields(new Field[]{new StringField(w.toString())});
                            this.writer.put((Record)record, 5L, TimeUnit.SECONDS);
                        }
                    }
                    catch (Exception e4) {
                        logger.error((Object)"could not write out asynchronous response ", (Throwable)e4);
                    }
                    if (this.writer.getStatus() != IBuffer.Status.Dispose) {
                        try {
                            this.writer.close();
                        }
                        catch (GRS2WriterException e5) {
                            logger.warn((Object)"error closing the resultset", (Throwable)e5);
                        }
                    }
                }
            }
        }
    }
}

