/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tm.services;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBERetryEquivalentFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.generators.Generator;
import org.gcube.data.tm.context.ServiceContext;
import org.gcube.data.tm.context.TReaderContext;
import org.gcube.data.tm.state.TReaderResource;
import org.gcube.data.tm.stubs.AnyHolder;
import org.gcube.data.tm.stubs.GetByIDParams;
import org.gcube.data.tm.stubs.GetByIDsParams;
import org.gcube.data.tm.stubs.GetParams;
import org.gcube.data.tm.stubs.InvalidTreeFault;
import org.gcube.data.tm.stubs.Path;
import org.gcube.data.tm.stubs.UnknownPathFault;
import org.gcube.data.tm.stubs.UnknownTreeFault;
import org.gcube.data.tm.stubs.UnsupportedOperationFault;
import org.gcube.data.tm.stubs.UnsupportedRequestFault;
import org.gcube.data.tml.exceptions.InvalidTreeException;
import org.gcube.data.tml.exceptions.UnknownPathException;
import org.gcube.data.tml.exceptions.UnknownTreeException;
import org.gcube.data.tml.exceptions.UnsupportedOperationException;
import org.gcube.data.tml.exceptions.UnsupportedRequestException;
import org.gcube.data.tml.utils.Utils;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.io.Bindings;
import org.gcube.data.trees.patterns.Pattern;
import org.gcube.data.trees.streams.TreeStreams;
import org.globus.wsrf.ResourceException;
import org.w3c.dom.Element;

public class TReaderService {
    public TReaderResource resource() throws ResourceException {
        return (TReaderResource)TReaderContext.getContext().getWSHome().find();
    }

    public AnyHolder getByID(GetByIDParams params) throws UnsupportedOperationFault, UnsupportedRequestFault, UnknownTreeFault, InvalidTreeFault, GCUBEFault {
        try {
            Pattern pattern = Utils.getPattern((AnyHolder)params.getPattern());
            Tree tree = this.resource().get(params.getRootID(), pattern);
            return Utils.toHolder((Tree)tree);
        }
        catch (UnsupportedOperationException e) {
            throw (UnsupportedOperationFault)Utils.newFault((GCUBEFault)new UnsupportedOperationFault(), (Throwable)e);
        }
        catch (UnsupportedRequestException e) {
            throw (UnsupportedRequestFault)Utils.newFault((GCUBEFault)new UnsupportedRequestFault(), (Throwable)e);
        }
        catch (UnknownTreeException e) {
            throw (UnknownTreeFault)Utils.newFault((GCUBEFault)new UnknownTreeFault(), (Throwable)e);
        }
        catch (InvalidTreeException e) {
            throw (InvalidTreeFault)Utils.newFault((GCUBEFault)new InvalidTreeFault(), (Throwable)e);
        }
        catch (Exception e) {
            throw (GCUBERetryEquivalentFault)Utils.newFault((GCUBEFault)new GCUBERetryEquivalentFault(), (Throwable)e);
        }
    }

    public String getByIDs(GetByIDsParams params) throws UnsupportedOperationFault, UnsupportedRequestFault, GCUBEFault {
        try {
            Pattern pattern = Utils.getPattern((AnyHolder)params.getPattern());
            URI rs = new URI(params.getLocator());
            Stream idStream = Streams.convert((URI)rs).ofStrings().withDefaults();
            Stream<Tree> outcome = this.resource().get((Stream<String>)idStream, pattern);
            URI rsTrees = TreeStreams.publishTreesIn(outcome).withBufferOf(25).withTimeoutOf(60, TimeUnit.SECONDS).with(ServiceContext.getContext().threadProvider()).withDefaults();
            return rsTrees.toString();
        }
        catch (URISyntaxException e) {
            throw (GCUBEUnrecoverableFault)Utils.newFault((GCUBEFault)new GCUBEUnrecoverableFault(), (Throwable)e);
        }
        catch (UnsupportedOperationException e) {
            throw (UnsupportedOperationFault)Utils.newFault((GCUBEFault)new UnsupportedOperationFault(), (Throwable)e);
        }
        catch (UnsupportedRequestException e) {
            throw (UnsupportedRequestFault)Utils.newFault((GCUBEFault)new UnsupportedRequestFault(), (Throwable)e);
        }
        catch (Exception e) {
            throw (GCUBERetryEquivalentFault)Utils.newFault((GCUBEFault)new GCUBERetryEquivalentFault(), (Throwable)e);
        }
    }

    public String get(GetParams params) throws UnsupportedOperationFault, UnsupportedRequestFault, GCUBEFault {
        try {
            Pattern pattern = Utils.getPattern((AnyHolder)params.getPattern());
            Stream<Tree> trees = this.resource().get(pattern);
            URI rs = Streams.publish(trees).using((Generator)new TreeStreams.TreeSerialiser()).withBufferOf(25).withTimeoutOf(60, TimeUnit.SECONDS).with(ServiceContext.getContext().threadProvider()).withDefaults();
            return rs.toString();
        }
        catch (UnsupportedOperationException e) {
            throw (UnsupportedOperationFault)Utils.newFault((GCUBEFault)new UnsupportedOperationFault(), (Throwable)e);
        }
        catch (UnsupportedRequestException e) {
            throw (UnsupportedRequestFault)Utils.newFault((GCUBEFault)new UnsupportedRequestFault(), (Throwable)e);
        }
        catch (Exception e) {
            throw (GCUBERetryEquivalentFault)Utils.newFault((GCUBEFault)new GCUBERetryEquivalentFault(), (Throwable)e);
        }
    }

    public AnyHolder getNode(Path path) throws UnsupportedOperationFault, UnsupportedRequestFault, UnknownPathFault, GCUBEFault {
        try {
            Node node = this.resource().getNode(path.getId());
            Element e = Bindings.nodeToElement((Node)node, (QName[])new QName[0]);
            return Utils.toHolder((Element)e);
        }
        catch (UnsupportedOperationException e) {
            throw (UnsupportedOperationFault)Utils.newFault((GCUBEFault)new UnsupportedOperationFault(), (Throwable)e);
        }
        catch (UnsupportedRequestException e) {
            throw (UnsupportedRequestFault)Utils.newFault((GCUBEFault)new UnsupportedRequestFault(), (Throwable)e);
        }
        catch (UnknownPathException e) {
            throw (UnknownPathFault)Utils.newFault((GCUBEFault)new UnknownPathFault(), (Throwable)e);
        }
        catch (Exception e) {
            throw (GCUBERetryEquivalentFault)Utils.newFault((GCUBEFault)new GCUBERetryEquivalentFault(), (Throwable)e);
        }
    }

    public String getNodes(String paths) throws UnsupportedOperationFault, UnsupportedRequestFault, GCUBEFault {
        try {
            Stream<Node> nodes = this.resource().getNodes(new URI(paths));
            URI nodesRs = TreeStreams.publishNodesIn(nodes).withBufferOf(25).withTimeoutOf(60, TimeUnit.SECONDS).with(ServiceContext.getContext().threadProvider()).withDefaults();
            return nodesRs.toString();
        }
        catch (URISyntaxException e) {
            throw (GCUBEUnrecoverableFault)Utils.newFault((GCUBEFault)new GCUBEUnrecoverableFault(), (Throwable)e);
        }
        catch (UnsupportedOperationException e) {
            throw (UnsupportedOperationFault)Utils.newFault((GCUBEFault)new UnsupportedOperationFault(), (Throwable)e);
        }
        catch (UnsupportedRequestException e) {
            throw (UnsupportedRequestFault)Utils.newFault((GCUBEFault)new UnsupportedRequestFault(), (Throwable)e);
        }
        catch (Exception e) {
            throw (GCUBERetryEquivalentFault)Utils.newFault((GCUBEFault)new GCUBERetryEquivalentFault(), (Throwable)e);
        }
    }
}

