/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tm.services;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.gcube.common.clients.exceptions.UnsupportedRequestException;
import org.gcube.common.core.faults.FaultUtils;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBERetryEquivalentFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.generators.Generator;
import org.gcube.data.tm.context.ServiceContext;
import org.gcube.data.tm.context.TReaderContext;
import org.gcube.data.tm.state.TReaderResource;
import org.gcube.data.tm.stubs.AnyHolder;
import org.gcube.data.tm.stubs.GetByIDParams;
import org.gcube.data.tm.stubs.GetByIDsParams;
import org.gcube.data.tm.stubs.GetParams;
import org.gcube.data.tm.stubs.InvalidTreeFault;
import org.gcube.data.tm.stubs.Path;
import org.gcube.data.tm.stubs.UnknownPathFault;
import org.gcube.data.tm.stubs.UnknownTreeFault;
import org.gcube.data.tm.stubs.UnsupportedOperationFault;
import org.gcube.data.tm.stubs.UnsupportedRequestFault;
import org.gcube.data.tmf.api.SourceReader;
import org.gcube.data.tml.exceptions.InvalidTreeException;
import org.gcube.data.tml.exceptions.UnknownPathException;
import org.gcube.data.tml.exceptions.UnknownTreeException;
import org.gcube.data.tml.utils.TMStreams;
import org.gcube.data.tml.utils.Utils;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.io.Bindings;
import org.gcube.data.trees.patterns.Pattern;
import org.gcube.data.trees.streams.TreeStreams;
import org.globus.wsrf.ResourceException;
import org.w3c.dom.Element;

public class TReaderService {
    public TReaderResource resource() throws ResourceException {
        return (TReaderResource)TReaderContext.getContext().getWSHome().find();
    }

    public AnyHolder getByID(GetByIDParams params) throws UnsupportedOperationFault, UnsupportedRequestFault, UnknownTreeFault, InvalidTreeFault, GCUBEFault {
        try {
            Pattern pattern = Utils.getPattern((AnyHolder)params.getPattern());
            SourceReader reader = this.resource().reader();
            Tree tree = reader.get(params.getRootID(), pattern);
            return Utils.toHolder((Tree)tree);
        }
        catch (UnsupportedOperationException e) {
            throw (UnsupportedOperationFault)FaultUtils.newFault((GCUBEFault)new UnsupportedOperationFault(), (Throwable)e);
        }
        catch (UnsupportedRequestException e) {
            throw (UnsupportedRequestFault)FaultUtils.newFault((GCUBEFault)new UnsupportedRequestFault(), (Throwable)e);
        }
        catch (UnknownTreeException e) {
            throw (UnknownTreeFault)FaultUtils.newFault((GCUBEFault)new UnknownTreeFault(), (Throwable)e);
        }
        catch (InvalidTreeException e) {
            throw (InvalidTreeFault)FaultUtils.newFault((GCUBEFault)new InvalidTreeFault(), (Throwable)e);
        }
        catch (Exception e) {
            throw (GCUBERetryEquivalentFault)FaultUtils.newFault((GCUBEFault)new GCUBERetryEquivalentFault(), (Throwable)e);
        }
    }

    public String getByIDs(GetByIDsParams params) throws UnsupportedOperationFault, UnsupportedRequestFault, GCUBEFault {
        try {
            Pattern pattern = Utils.getPattern((AnyHolder)params.getPattern());
            URI rs = new URI(params.getLocator());
            Stream idStream = Streams.convert((URI)rs).ofStrings().withDefaults();
            SourceReader reader = this.resource().reader();
            Stream outcome = TMStreams.log((Stream)reader.get(idStream, pattern));
            URI rsTrees = TreeStreams.publishTreesIn((Stream)outcome).withBufferOf(25).withTimeoutOf(60, TimeUnit.SECONDS).with(ServiceContext.getContext().threadProvider()).withDefaults();
            return rsTrees.toString();
        }
        catch (URISyntaxException e) {
            throw (GCUBEUnrecoverableFault)FaultUtils.newFault((GCUBEFault)new GCUBEUnrecoverableFault(), (Throwable)e);
        }
        catch (UnsupportedOperationException e) {
            throw (UnsupportedOperationFault)FaultUtils.newFault((GCUBEFault)new UnsupportedOperationFault(), (Throwable)e);
        }
        catch (UnsupportedRequestException e) {
            throw (UnsupportedRequestFault)FaultUtils.newFault((GCUBEFault)new UnsupportedRequestFault(), (Throwable)e);
        }
        catch (Exception e) {
            throw (GCUBERetryEquivalentFault)FaultUtils.newFault((GCUBEFault)new GCUBERetryEquivalentFault(), (Throwable)e);
        }
    }

    public String get(GetParams params) throws UnsupportedOperationFault, UnsupportedRequestFault, GCUBEFault {
        try {
            Pattern pattern = Utils.getPattern((AnyHolder)params.getPattern());
            SourceReader reader = this.resource().reader();
            Stream trees = TMStreams.log((Stream)reader.get(pattern));
            URI rs = Streams.publish((Stream)trees).using((Generator)new TreeStreams.TreeSerialiser()).withBufferOf(25).withTimeoutOf(60, TimeUnit.SECONDS).with(ServiceContext.getContext().threadProvider()).withDefaults();
            return rs.toString();
        }
        catch (UnsupportedOperationException e) {
            throw (UnsupportedOperationFault)FaultUtils.newFault((GCUBEFault)new UnsupportedOperationFault(), (Throwable)e);
        }
        catch (UnsupportedRequestException e) {
            throw (UnsupportedRequestFault)FaultUtils.newFault((GCUBEFault)new UnsupportedRequestFault(), (Throwable)e);
        }
        catch (Exception e) {
            throw (GCUBERetryEquivalentFault)FaultUtils.newFault((GCUBEFault)new GCUBERetryEquivalentFault(), (Throwable)e);
        }
    }

    public AnyHolder getNode(Path path) throws UnsupportedOperationFault, UnsupportedRequestFault, UnknownPathFault, GCUBEFault {
        try {
            SourceReader reader = this.resource().reader();
            Node node = reader.getNode(path.getId());
            Element e = Bindings.nodeToElement((Node)node, (QName[])new QName[0]);
            return Utils.toHolder((Element)e);
        }
        catch (UnsupportedOperationException e) {
            throw (UnsupportedOperationFault)FaultUtils.newFault((GCUBEFault)new UnsupportedOperationFault(), (Throwable)e);
        }
        catch (UnsupportedRequestException e) {
            throw (UnsupportedRequestFault)FaultUtils.newFault((GCUBEFault)new UnsupportedRequestFault(), (Throwable)e);
        }
        catch (UnknownPathException e) {
            throw (UnknownPathFault)FaultUtils.newFault((GCUBEFault)new UnknownPathFault(), (Throwable)e);
        }
        catch (Exception e) {
            throw (GCUBERetryEquivalentFault)FaultUtils.newFault((GCUBEFault)new GCUBERetryEquivalentFault(), (Throwable)e);
        }
    }

    public String getNodes(String pathsRs) throws UnsupportedOperationFault, UnsupportedRequestFault, GCUBEFault {
        try {
            Stream paths = TMStreams.pathsIn((URI)new URI(pathsRs));
            SourceReader reader = this.resource().reader();
            Stream nodes = TMStreams.log((Stream)reader.getNodes(paths));
            URI nodesRs = TreeStreams.publishNodesIn((Stream)nodes).withBufferOf(25).withTimeoutOf(60, TimeUnit.SECONDS).with(ServiceContext.getContext().threadProvider()).withDefaults();
            return nodesRs.toString();
        }
        catch (URISyntaxException e) {
            throw (GCUBEUnrecoverableFault)FaultUtils.newFault((GCUBEFault)new GCUBEUnrecoverableFault(), (Throwable)e);
        }
        catch (UnsupportedOperationException e) {
            throw (UnsupportedOperationFault)FaultUtils.newFault((GCUBEFault)new UnsupportedOperationFault(), (Throwable)e);
        }
        catch (UnsupportedRequestException e) {
            throw (UnsupportedRequestFault)FaultUtils.newFault((GCUBEFault)new UnsupportedRequestFault(), (Throwable)e);
        }
        catch (Exception e) {
            throw (GCUBERetryEquivalentFault)FaultUtils.newFault((GCUBEFault)new GCUBERetryEquivalentFault(), (Throwable)e);
        }
    }
}

