/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tm.services;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.gcube.common.core.faults.FaultUtils;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBERetryEquivalentFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.generators.Generator;
import org.gcube.data.tm.context.TReaderContext;
import org.gcube.data.tm.state.TReaderResource;
import org.gcube.data.tm.stubs.AnyHolder;
import org.gcube.data.tm.stubs.GetByIDParams;
import org.gcube.data.tm.stubs.GetByIDsParams;
import org.gcube.data.tm.stubs.GetParams;
import org.gcube.data.tm.stubs.InvalidTreeFault;
import org.gcube.data.tm.stubs.Path;
import org.gcube.data.tm.stubs.UnknownPathFault;
import org.gcube.data.tm.stubs.UnknownTreeFault;
import org.gcube.data.tm.stubs.UnsupportedOperationFault;
import org.gcube.data.tm.stubs.UnsupportedRequestFault;
import org.gcube.data.tm.utils.TMStreams;
import org.gcube.data.tm.utils.Utils;
import org.gcube.data.tmf.api.SourceReader;
import org.gcube.data.tmf.api.exceptions.InvalidTreeException;
import org.gcube.data.tmf.api.exceptions.UnknownPathException;
import org.gcube.data.tmf.api.exceptions.UnknownTreeException;
import org.gcube.data.tmf.api.exceptions.UnsupportedRequestException;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.io.XMLBindings;
import org.gcube.data.trees.patterns.Pattern;
import org.gcube.data.trees.streams.TreeStreams;
import org.globus.wsrf.ResourceException;
import org.w3c.dom.Element;

public class TReaderService {
    public TReaderResource resource() throws ResourceException {
        return (TReaderResource)TReaderContext.getContext().getWSHome().find();
    }

    public AnyHolder getByID(GetByIDParams params) throws UnsupportedOperationFault, UnsupportedRequestFault, UnknownTreeFault, InvalidTreeFault, GCUBEFault {
        try {
            Pattern pattern = Utils.toPattern(params.getPattern());
            SourceReader reader = this.resource().reader();
            Tree tree = reader.get(params.getRootID(), pattern);
            return Utils.toAnyHolder(tree);
        }
        catch (UnsupportedOperationException e) {
            throw (UnsupportedOperationFault)FaultUtils.newFault((GCUBEFault)new UnsupportedOperationFault(), (Throwable)e);
        }
        catch (UnsupportedRequestException e) {
            throw (UnsupportedRequestFault)FaultUtils.newFault((GCUBEFault)new UnsupportedRequestFault(), (Throwable)e);
        }
        catch (UnknownTreeException e) {
            throw (UnknownTreeFault)FaultUtils.newFault((GCUBEFault)new UnknownTreeFault(), (Throwable)e);
        }
        catch (InvalidTreeException e) {
            throw (InvalidTreeFault)FaultUtils.newFault((GCUBEFault)new InvalidTreeFault(), (Throwable)e);
        }
        catch (Exception e) {
            throw (GCUBERetryEquivalentFault)FaultUtils.newFault((GCUBEFault)new GCUBERetryEquivalentFault(), (Throwable)e);
        }
    }

    public String getByIDs(GetByIDsParams params) throws UnsupportedOperationFault, UnsupportedRequestFault, GCUBEFault {
        try {
            Pattern pattern = Utils.toPattern(params.getPattern());
            URI rs = new URI(params.getLocator());
            Stream idStream = Streams.convert((URI)rs).ofStrings().withDefaults();
            SourceReader reader = this.resource().reader();
            Stream outcome = TMStreams.log(reader.get(idStream, pattern));
            URI rsTrees = TreeStreams.publishTreesIn(outcome).withBufferOf(25).withTimeoutOf(60, TimeUnit.SECONDS).withDefaults();
            return rsTrees.toString();
        }
        catch (URISyntaxException e) {
            throw (GCUBEUnrecoverableFault)FaultUtils.newFault((GCUBEFault)new GCUBEUnrecoverableFault(), (Throwable)e);
        }
        catch (UnsupportedOperationException e) {
            throw (UnsupportedOperationFault)FaultUtils.newFault((GCUBEFault)new UnsupportedOperationFault(), (Throwable)e);
        }
        catch (UnsupportedRequestException e) {
            throw (UnsupportedRequestFault)FaultUtils.newFault((GCUBEFault)new UnsupportedRequestFault(), (Throwable)e);
        }
        catch (Exception e) {
            throw (GCUBERetryEquivalentFault)FaultUtils.newFault((GCUBEFault)new GCUBERetryEquivalentFault(), (Throwable)e);
        }
    }

    public String get(GetParams params) throws UnsupportedOperationFault, UnsupportedRequestFault, GCUBEFault {
        try {
            Pattern pattern = Utils.toPattern(params.getPattern());
            SourceReader reader = this.resource().reader();
            Stream trees = TMStreams.log(reader.get(pattern));
            URI rs = Streams.publish(trees).using((Generator)new TreeStreams.TreeSerialiser()).withBufferOf(25).withTimeoutOf(60, TimeUnit.SECONDS).withDefaults();
            return rs.toString();
        }
        catch (UnsupportedOperationException e) {
            throw (UnsupportedOperationFault)FaultUtils.newFault((GCUBEFault)new UnsupportedOperationFault(), (Throwable)e);
        }
        catch (UnsupportedRequestException e) {
            throw (UnsupportedRequestFault)FaultUtils.newFault((GCUBEFault)new UnsupportedRequestFault(), (Throwable)e);
        }
        catch (Exception e) {
            throw (GCUBERetryEquivalentFault)FaultUtils.newFault((GCUBEFault)new GCUBERetryEquivalentFault(), (Throwable)e);
        }
    }

    public AnyHolder getNode(Path path) throws UnsupportedOperationFault, UnsupportedRequestFault, UnknownPathFault, GCUBEFault {
        try {
            SourceReader reader = this.resource().reader();
            Node node = reader.getNode(path.getId());
            Element e = XMLBindings.nodeToElement((Node)node);
            return Utils.toHolder(e);
        }
        catch (UnsupportedOperationException e) {
            throw (UnsupportedOperationFault)FaultUtils.newFault((GCUBEFault)new UnsupportedOperationFault(), (Throwable)e);
        }
        catch (UnsupportedRequestException e) {
            throw (UnsupportedRequestFault)FaultUtils.newFault((GCUBEFault)new UnsupportedRequestFault(), (Throwable)e);
        }
        catch (UnknownPathException e) {
            throw (UnknownPathFault)FaultUtils.newFault((GCUBEFault)new UnknownPathFault(), (Throwable)e);
        }
        catch (Exception e) {
            throw (GCUBERetryEquivalentFault)FaultUtils.newFault((GCUBEFault)new GCUBERetryEquivalentFault(), (Throwable)e);
        }
    }

    public String getNodes(String pathsRs) throws UnsupportedOperationFault, UnsupportedRequestFault, GCUBEFault {
        try {
            Stream<org.gcube.data.tmf.api.Path> paths = TMStreams.pathsIn(new URI(pathsRs));
            SourceReader reader = this.resource().reader();
            Stream nodes = TMStreams.log(reader.getNodes(paths));
            URI nodesRs = TreeStreams.publishNodesIn(nodes).withBufferOf(25).withTimeoutOf(60, TimeUnit.SECONDS).withDefaults();
            return nodesRs.toString();
        }
        catch (URISyntaxException e) {
            throw (GCUBEUnrecoverableFault)FaultUtils.newFault((GCUBEFault)new GCUBEUnrecoverableFault(), (Throwable)e);
        }
        catch (UnsupportedOperationException e) {
            throw (UnsupportedOperationFault)FaultUtils.newFault((GCUBEFault)new UnsupportedOperationFault(), (Throwable)e);
        }
        catch (UnsupportedRequestException e) {
            throw (UnsupportedRequestFault)FaultUtils.newFault((GCUBEFault)new UnsupportedRequestFault(), (Throwable)e);
        }
        catch (Exception e) {
            throw (GCUBERetryEquivalentFault)FaultUtils.newFault((GCUBEFault)new GCUBERetryEquivalentFault(), (Throwable)e);
        }
    }
}

