package org.gcube.data.access.trees.resolver;

import static org.gcube.data.tml.proxies.TServiceFactory.*;
import static org.slf4j.LoggerFactory.*;

import java.util.List;

import org.gcube.common.clients.ClientRuntime;
import org.gcube.common.clients.exceptions.DiscoveryException;
import org.gcube.common.clients.fw.queries.StatefulQuery;
import org.gcube.data.tml.exceptions.UnknownPathException;
import org.gcube.data.tml.exceptions.UnknownTreeException;
import org.gcube.data.tml.proxies.TReader;
import org.gcube.data.trees.data.Node;
import org.slf4j.Logger;

public class DefaultResolver implements Resolver {

	private Logger logger = getLogger(DefaultResolver.class);
	
	public DefaultResolver() {
		ClientRuntime.start();
	}
	
	public Node resolve(String source,List<String> elements) throws DiscoveryException, UnknownTreeException, UnknownPathException {
		
		logger.trace("resolving {} in {}",elements,source);
		
		StatefulQuery query = readSource().withId(source).build();
		TReader reader = reader().matching(query).build();
		
		if (elements.size()==1)
			return reader.get(elements.get(0));
		else
			return reader.getNode(elements.toArray(new String[0]));
		
	}
}
