/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.trees.resolver;

import java.io.StringWriter;
import java.io.Writer;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.gcube.common.clients.exceptions.DiscoveryException;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.access.trees.resolver.DependencyProvider;
import org.gcube.data.access.trees.resolver.Resolver;
import org.gcube.data.tml.exceptions.UnknownPathException;
import org.gcube.data.tml.exceptions.UnknownTreeException;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.io.XMLBindings;
import org.gcube.data.trees.uri.TreeUriBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/{path:.*}")
public class ResolverService {
    private Logger logger = LoggerFactory.getLogger(ResolverService.class);

    @GET
    @Produces(value={"application/xml"})
    public String resolve(@Context UriInfo info) {
        try {
            TreeUriBean bean = new TreeUriBean(info.getRequestUri());
            ScopeProvider.instance.set(bean.scope());
            Resolver resolver = DependencyProvider.resolver();
            Node resolved = resolver.resolve(bean.sourceId(), bean.nodeIDs());
            return resolved instanceof Tree ? this.serialiseTree((Tree)resolved) : this.serialiseNode(resolved);
        }
        catch (IllegalArgumentException e) {
            throw this.exception(info, Response.Status.BAD_REQUEST, (Throwable)e);
        }
        catch (DiscoveryException e) {
            throw this.exception(info, Response.Status.NOT_FOUND, (Throwable)e);
        }
        catch (UnknownTreeException e) {
            throw this.exception(info, Response.Status.NOT_FOUND, (Throwable)e);
        }
        catch (UnknownPathException e) {
            throw this.exception(info, Response.Status.NOT_FOUND, (Throwable)e);
        }
        catch (Exception e) {
            throw this.exception(info, Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    WebApplicationException exception(UriInfo info, Response.Status status, Throwable t) {
        this.logger.error("could not resolve " + info.getRequestUri(), t);
        Response error = Response.status((Response.Status)status).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)t.getMessage()).build();
        return new WebApplicationException(error);
    }

    private String serialiseTree(Tree tree) throws Exception {
        return XMLBindings.toString((Tree)tree);
    }

    private String serialiseNode(Node node) throws Exception {
        StringWriter writer = new StringWriter();
        XMLBindings.nodeToStream((Node)node, (Writer)writer);
        return writer.toString();
    }
}

